/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.imagebuilder.model.PipelineExecutionStartCondition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Schedule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Schedule> {
    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scheduleExpression").getter(Schedule.getter(Schedule::scheduleExpression)).setter(Schedule.setter(Builder::scheduleExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleExpression").build()}).build();
    private static final SdkField<String> PIPELINE_EXECUTION_START_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pipelineExecutionStartCondition").getter(Schedule.getter(Schedule::pipelineExecutionStartConditionAsString)).setter(Schedule.setter(Builder::pipelineExecutionStartCondition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineExecutionStartCondition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_EXPRESSION_FIELD, PIPELINE_EXECUTION_START_CONDITION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String scheduleExpression;
    private final String pipelineExecutionStartCondition;

    private Schedule(BuilderImpl builder) {
        this.scheduleExpression = builder.scheduleExpression;
        this.pipelineExecutionStartCondition = builder.pipelineExecutionStartCondition;
    }

    public String scheduleExpression() {
        return this.scheduleExpression;
    }

    public PipelineExecutionStartCondition pipelineExecutionStartCondition() {
        return PipelineExecutionStartCondition.fromValue(this.pipelineExecutionStartCondition);
    }

    public String pipelineExecutionStartConditionAsString() {
        return this.pipelineExecutionStartCondition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineExecutionStartConditionAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Schedule)) {
            return false;
        }
        Schedule other = (Schedule)obj;
        return Objects.equals(this.scheduleExpression(), other.scheduleExpression()) && Objects.equals(this.pipelineExecutionStartConditionAsString(), other.pipelineExecutionStartConditionAsString());
    }

    public String toString() {
        return ToString.builder((String)"Schedule").add("ScheduleExpression", (Object)this.scheduleExpression()).add("PipelineExecutionStartCondition", (Object)this.pipelineExecutionStartConditionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scheduleExpression": {
                return Optional.ofNullable(clazz.cast(this.scheduleExpression()));
            }
            case "pipelineExecutionStartCondition": {
                return Optional.ofNullable(clazz.cast(this.pipelineExecutionStartConditionAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Schedule, T> g) {
        return obj -> g.apply((Schedule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String scheduleExpression;
        private String pipelineExecutionStartCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(Schedule model) {
            this.scheduleExpression(model.scheduleExpression);
            this.pipelineExecutionStartCondition(model.pipelineExecutionStartCondition);
        }

        public final String getScheduleExpression() {
            return this.scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        public final String getPipelineExecutionStartCondition() {
            return this.pipelineExecutionStartCondition;
        }

        @Override
        public final Builder pipelineExecutionStartCondition(String pipelineExecutionStartCondition) {
            this.pipelineExecutionStartCondition = pipelineExecutionStartCondition;
            return this;
        }

        @Override
        public final Builder pipelineExecutionStartCondition(PipelineExecutionStartCondition pipelineExecutionStartCondition) {
            this.pipelineExecutionStartCondition(pipelineExecutionStartCondition == null ? null : pipelineExecutionStartCondition.toString());
            return this;
        }

        public final void setPipelineExecutionStartCondition(String pipelineExecutionStartCondition) {
            this.pipelineExecutionStartCondition = pipelineExecutionStartCondition;
        }

        public Schedule build() {
            return new Schedule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Schedule> {
        public Builder scheduleExpression(String var1);

        public Builder pipelineExecutionStartCondition(String var1);

        public Builder pipelineExecutionStartCondition(PipelineExecutionStartCondition var1);
    }
}

