/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ComponentFormat {
    SHELL("SHELL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ComponentFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ComponentFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ComponentFormat.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ComponentFormat> knownValues() {
        return Stream.of(ComponentFormat.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

