/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.imagebuilder.model.Distribution;
import software.amazon.awssdk.services.imagebuilder.model.DistributionListCopier;
import software.amazon.awssdk.services.imagebuilder.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DistributionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DistributionConfiguration> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(DistributionConfiguration.getter(DistributionConfiguration::arn)).setter(DistributionConfiguration.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DistributionConfiguration.getter(DistributionConfiguration::name)).setter(DistributionConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(DistributionConfiguration.getter(DistributionConfiguration::description)).setter(DistributionConfiguration.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<Distribution>> DISTRIBUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("distributions").getter(DistributionConfiguration.getter(DistributionConfiguration::distributions)).setter(DistributionConfiguration.setter(Builder::distributions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Distribution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> TIMEOUT_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("timeoutMinutes").getter(DistributionConfiguration.getter(DistributionConfiguration::timeoutMinutes)).setter(DistributionConfiguration.setter(Builder::timeoutMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutMinutes").build()}).build();
    private static final SdkField<String> DATE_CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dateCreated").getter(DistributionConfiguration.getter(DistributionConfiguration::dateCreated)).setter(DistributionConfiguration.setter(Builder::dateCreated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateCreated").build()}).build();
    private static final SdkField<String> DATE_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dateUpdated").getter(DistributionConfiguration.getter(DistributionConfiguration::dateUpdated)).setter(DistributionConfiguration.setter(Builder::dateUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateUpdated").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(DistributionConfiguration.getter(DistributionConfiguration::tags)).setter(DistributionConfiguration.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, DISTRIBUTIONS_FIELD, TIMEOUT_MINUTES_FIELD, DATE_CREATED_FIELD, DATE_UPDATED_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String description;
    private final List<Distribution> distributions;
    private final Integer timeoutMinutes;
    private final String dateCreated;
    private final String dateUpdated;
    private final Map<String, String> tags;

    private DistributionConfiguration(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.distributions = builder.distributions;
        this.timeoutMinutes = builder.timeoutMinutes;
        this.dateCreated = builder.dateCreated;
        this.dateUpdated = builder.dateUpdated;
        this.tags = builder.tags;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public boolean hasDistributions() {
        return this.distributions != null && !(this.distributions instanceof SdkAutoConstructList);
    }

    public List<Distribution> distributions() {
        return this.distributions;
    }

    public Integer timeoutMinutes() {
        return this.timeoutMinutes;
    }

    public String dateCreated() {
        return this.dateCreated;
    }

    public String dateUpdated() {
        return this.dateUpdated;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.distributions());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DistributionConfiguration)) {
            return false;
        }
        DistributionConfiguration other = (DistributionConfiguration)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.distributions(), other.distributions()) && Objects.equals(this.timeoutMinutes(), other.timeoutMinutes()) && Objects.equals(this.dateCreated(), other.dateCreated()) && Objects.equals(this.dateUpdated(), other.dateUpdated()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"DistributionConfiguration").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Distributions", this.distributions()).add("TimeoutMinutes", (Object)this.timeoutMinutes()).add("DateCreated", (Object)this.dateCreated()).add("DateUpdated", (Object)this.dateUpdated()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "distributions": {
                return Optional.ofNullable(clazz.cast(this.distributions()));
            }
            case "timeoutMinutes": {
                return Optional.ofNullable(clazz.cast(this.timeoutMinutes()));
            }
            case "dateCreated": {
                return Optional.ofNullable(clazz.cast(this.dateCreated()));
            }
            case "dateUpdated": {
                return Optional.ofNullable(clazz.cast(this.dateUpdated()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DistributionConfiguration, T> g) {
        return obj -> g.apply((DistributionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String description;
        private List<Distribution> distributions = DefaultSdkAutoConstructList.getInstance();
        private Integer timeoutMinutes;
        private String dateCreated;
        private String dateUpdated;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DistributionConfiguration model) {
            this.arn(model.arn);
            this.name(model.name);
            this.description(model.description);
            this.distributions(model.distributions);
            this.timeoutMinutes(model.timeoutMinutes);
            this.dateCreated(model.dateCreated);
            this.dateUpdated(model.dateUpdated);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Distribution.Builder> getDistributions() {
            return this.distributions != null ? (Collection)this.distributions.stream().map(Distribution::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder distributions(Collection<Distribution> distributions) {
            this.distributions = DistributionListCopier.copy(distributions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder distributions(Distribution ... distributions) {
            this.distributions(Arrays.asList(distributions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder distributions(Consumer<Distribution.Builder> ... distributions) {
            this.distributions(Stream.of(distributions).map(c -> (Distribution)((Distribution.Builder)Distribution.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDistributions(Collection<Distribution.BuilderImpl> distributions) {
            this.distributions = DistributionListCopier.copyFromBuilder(distributions);
        }

        public final Integer getTimeoutMinutes() {
            return this.timeoutMinutes;
        }

        @Override
        public final Builder timeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
            return this;
        }

        public final void setTimeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
        }

        public final String getDateCreated() {
            return this.dateCreated;
        }

        @Override
        public final Builder dateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final void setDateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
        }

        public final String getDateUpdated() {
            return this.dateUpdated;
        }

        @Override
        public final Builder dateUpdated(String dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public final void setDateUpdated(String dateUpdated) {
            this.dateUpdated = dateUpdated;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public DistributionConfiguration build() {
            return new DistributionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DistributionConfiguration> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder distributions(Collection<Distribution> var1);

        public Builder distributions(Distribution ... var1);

        public Builder distributions(Consumer<Distribution.Builder> ... var1);

        public Builder timeoutMinutes(Integer var1);

        public Builder dateCreated(String var1);

        public Builder dateUpdated(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

