/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateImageRecipeResponse
extends ImagebuilderResponse
implements ToCopyableBuilder<Builder, CreateImageRecipeResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateImageRecipeResponse.getter(CreateImageRecipeResponse::requestId)).setter(CreateImageRecipeResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateImageRecipeResponse.getter(CreateImageRecipeResponse::clientToken)).setter(CreateImageRecipeResponse.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final SdkField<String> IMAGE_RECIPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateImageRecipeResponse.getter(CreateImageRecipeResponse::imageRecipeArn)).setter(CreateImageRecipeResponse.setter(Builder::imageRecipeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageRecipeArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, CLIENT_TOKEN_FIELD, IMAGE_RECIPE_ARN_FIELD));
    private final String requestIdValue;
    private final String clientToken;
    private final String imageRecipeArn;

    private CreateImageRecipeResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.clientToken = builder.clientToken;
        this.imageRecipeArn = builder.imageRecipeArn;
    }

    public String requestId() {
        return this.requestIdValue;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public String imageRecipeArn() {
        return this.imageRecipeArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageRecipeArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateImageRecipeResponse)) {
            return false;
        }
        CreateImageRecipeResponse other = (CreateImageRecipeResponse)((Object)obj);
        return Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.imageRecipeArn(), other.imageRecipeArn());
    }

    public String toString() {
        return ToString.builder((String)"CreateImageRecipeResponse").add("RequestId", (Object)this.requestId()).add("ClientToken", (Object)this.clientToken()).add("ImageRecipeArn", (Object)this.imageRecipeArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "imageRecipeArn": {
                return Optional.ofNullable(clazz.cast(this.imageRecipeArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateImageRecipeResponse, T> g) {
        return obj -> g.apply((CreateImageRecipeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderResponse.BuilderImpl
    implements Builder {
        private String requestIdValue;
        private String clientToken;
        private String imageRecipeArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateImageRecipeResponse model) {
            super(model);
            this.requestId(model.requestIdValue);
            this.clientToken(model.clientToken);
            this.imageRecipeArn(model.imageRecipeArn);
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getImageRecipeArn() {
            return this.imageRecipeArn;
        }

        @Override
        public final Builder imageRecipeArn(String imageRecipeArn) {
            this.imageRecipeArn = imageRecipeArn;
            return this;
        }

        public final void setImageRecipeArn(String imageRecipeArn) {
            this.imageRecipeArn = imageRecipeArn;
        }

        @Override
        public CreateImageRecipeResponse build() {
            return new CreateImageRecipeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ImagebuilderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateImageRecipeResponse> {
        public Builder requestId(String var1);

        public Builder clientToken(String var1);

        public Builder imageRecipeArn(String var1);
    }
}

