/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.imagebuilder.model.ImageSummary;
import software.amazon.awssdk.services.imagebuilder.model.ImageSummaryListCopier;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListImagePipelineImagesResponse
extends ImagebuilderResponse
implements ToCopyableBuilder<Builder, ListImagePipelineImagesResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListImagePipelineImagesResponse.getter(ListImagePipelineImagesResponse::requestId)).setter(ListImagePipelineImagesResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()}).build();
    private static final SdkField<List<ImageSummary>> IMAGE_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListImagePipelineImagesResponse.getter(ListImagePipelineImagesResponse::imageSummaryList)).setter(ListImagePipelineImagesResponse.setter(Builder::imageSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImageSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListImagePipelineImagesResponse.getter(ListImagePipelineImagesResponse::nextToken)).setter(ListImagePipelineImagesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, IMAGE_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final String requestIdValue;
    private final List<ImageSummary> imageSummaryList;
    private final String nextToken;

    private ListImagePipelineImagesResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.imageSummaryList = builder.imageSummaryList;
        this.nextToken = builder.nextToken;
    }

    public String requestId() {
        return this.requestIdValue;
    }

    public boolean hasImageSummaryList() {
        return this.imageSummaryList != null && !(this.imageSummaryList instanceof SdkAutoConstructList);
    }

    public List<ImageSummary> imageSummaryList() {
        return this.imageSummaryList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageSummaryList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImagePipelineImagesResponse)) {
            return false;
        }
        ListImagePipelineImagesResponse other = (ListImagePipelineImagesResponse)((Object)obj);
        return Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.imageSummaryList(), other.imageSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListImagePipelineImagesResponse").add("RequestId", (Object)this.requestId()).add("ImageSummaryList", this.imageSummaryList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "imageSummaryList": {
                return Optional.ofNullable(clazz.cast(this.imageSummaryList()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListImagePipelineImagesResponse, T> g) {
        return obj -> g.apply((ListImagePipelineImagesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderResponse.BuilderImpl
    implements Builder {
        private String requestIdValue;
        private List<ImageSummary> imageSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImagePipelineImagesResponse model) {
            super(model);
            this.requestId(model.requestIdValue);
            this.imageSummaryList(model.imageSummaryList);
            this.nextToken(model.nextToken);
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        public final Collection<ImageSummary.Builder> getImageSummaryList() {
            return this.imageSummaryList != null ? (Collection)this.imageSummaryList.stream().map(ImageSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder imageSummaryList(Collection<ImageSummary> imageSummaryList) {
            this.imageSummaryList = ImageSummaryListCopier.copy(imageSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageSummaryList(ImageSummary ... imageSummaryList) {
            this.imageSummaryList(Arrays.asList(imageSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageSummaryList(Consumer<ImageSummary.Builder> ... imageSummaryList) {
            this.imageSummaryList(Stream.of(imageSummaryList).map(c -> (ImageSummary)((ImageSummary.Builder)ImageSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setImageSummaryList(Collection<ImageSummary.BuilderImpl> imageSummaryList) {
            this.imageSummaryList = ImageSummaryListCopier.copyFromBuilder(imageSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListImagePipelineImagesResponse build() {
            return new ListImagePipelineImagesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ImagebuilderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListImagePipelineImagesResponse> {
        public Builder requestId(String var1);

        public Builder imageSummaryList(Collection<ImageSummary> var1);

        public Builder imageSummaryList(ImageSummary ... var1);

        public Builder imageSummaryList(Consumer<ImageSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

