/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ImageStatus {
    PENDING("PENDING"),
    CREATING("CREATING"),
    BUILDING("BUILDING"),
    TESTING("TESTING"),
    DISTRIBUTING("DISTRIBUTING"),
    INTEGRATING("INTEGRATING"),
    AVAILABLE("AVAILABLE"),
    CANCELLED("CANCELLED"),
    FAILED("FAILED"),
    DEPRECATED("DEPRECATED"),
    DELETED("DELETED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ImageStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImageStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ImageStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImageStatus> knownValues() {
        return Stream.of(ImageStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

