/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Logging configuration defines where Image Builder uploads your logs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Logging implements SdkPojo, Serializable, ToCopyableBuilder<Logging.Builder, Logging> {
    private static final SdkField<S3Logs> S3_LOGS_FIELD = SdkField.<S3Logs> builder(MarshallingType.SDK_POJO)
            .getter(getter(Logging::s3Logs)).setter(setter(Builder::s3Logs)).constructor(S3Logs::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Logs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_LOGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3Logs s3Logs;

    private Logging(BuilderImpl builder) {
        this.s3Logs = builder.s3Logs;
    }

    /**
     * <p>
     * The Amazon S3 logging configuration.
     * </p>
     * 
     * @return The Amazon S3 logging configuration.
     */
    public S3Logs s3Logs() {
        return s3Logs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Logs());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Logging)) {
            return false;
        }
        Logging other = (Logging) obj;
        return Objects.equals(s3Logs(), other.s3Logs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Logging").add("S3Logs", s3Logs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3Logs":
            return Optional.ofNullable(clazz.cast(s3Logs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Logging, T> g) {
        return obj -> g.apply((Logging) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Logging> {
        /**
         * <p>
         * The Amazon S3 logging configuration.
         * </p>
         * 
         * @param s3Logs
         *        The Amazon S3 logging configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Logs(S3Logs s3Logs);

        /**
         * <p>
         * The Amazon S3 logging configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link S3Logs.Builder} avoiding the need to create one
         * manually via {@link S3Logs#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Logs.Builder#build()} is called immediately and its result is
         * passed to {@link #s3Logs(S3Logs)}.
         * 
         * @param s3Logs
         *        a consumer that will call methods on {@link S3Logs.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Logs(S3Logs)
         */
        default Builder s3Logs(Consumer<S3Logs.Builder> s3Logs) {
            return s3Logs(S3Logs.builder().applyMutation(s3Logs).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3Logs s3Logs;

        private BuilderImpl() {
        }

        private BuilderImpl(Logging model) {
            s3Logs(model.s3Logs);
        }

        public final S3Logs.Builder getS3Logs() {
            return s3Logs != null ? s3Logs.toBuilder() : null;
        }

        @Override
        public final Builder s3Logs(S3Logs s3Logs) {
            this.s3Logs = s3Logs;
            return this;
        }

        public final void setS3Logs(S3Logs.BuilderImpl s3Logs) {
            this.s3Logs = s3Logs != null ? s3Logs.build() : null;
        }

        @Override
        public Logging build() {
            return new Logging(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
