/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderClient;
import software.amazon.awssdk.services.imagebuilder.model.ListImagesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImagesResponse;

public class ListImagesIterable
implements SdkIterable<ListImagesResponse> {
    private final ImagebuilderClient client;
    private final ListImagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListImagesIterable(ImagebuilderClient client, ListImagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListImagesResponseFetcher();
    }

    public Iterator<ListImagesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListImagesResponseFetcher
    implements SyncPageFetcher<ListImagesResponse> {
        private ListImagesResponseFetcher() {
        }

        public boolean hasNextPage(ListImagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListImagesResponse nextPage(ListImagesResponse previousPage) {
            if (previousPage == null) {
                return ListImagesIterable.this.client.listImages(ListImagesIterable.this.firstRequest);
            }
            return ListImagesIterable.this.client.listImages((ListImagesRequest)((Object)ListImagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

