/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ComponentType {
    BUILD("BUILD"),
    TEST("TEST"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ComponentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ComponentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ComponentType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ComponentType> knownValues() {
        return Stream.of(ComponentType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

