/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.imagebuilder.model.Platform;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageVersion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageVersion> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImageVersion.getter(ImageVersion::arn)).setter(ImageVersion.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImageVersion.getter(ImageVersion::name)).setter(ImageVersion.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImageVersion.getter(ImageVersion::version)).setter(ImageVersion.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImageVersion.getter(ImageVersion::platformAsString)).setter(ImageVersion.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImageVersion.getter(ImageVersion::owner)).setter(ImageVersion.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()}).build();
    private static final SdkField<String> DATE_CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImageVersion.getter(ImageVersion::dateCreated)).setter(ImageVersion.setter(Builder::dateCreated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateCreated").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, VERSION_FIELD, PLATFORM_FIELD, OWNER_FIELD, DATE_CREATED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String version;
    private final String platform;
    private final String owner;
    private final String dateCreated;

    private ImageVersion(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.version = builder.version;
        this.platform = builder.platform;
        this.owner = builder.owner;
        this.dateCreated = builder.dateCreated;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public String version() {
        return this.version;
    }

    public Platform platform() {
        return Platform.fromValue(this.platform);
    }

    public String platformAsString() {
        return this.platform;
    }

    public String owner() {
        return this.owner;
    }

    public String dateCreated() {
        return this.dateCreated;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateCreated());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageVersion)) {
            return false;
        }
        ImageVersion other = (ImageVersion)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.platformAsString(), other.platformAsString()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.dateCreated(), other.dateCreated());
    }

    public String toString() {
        return ToString.builder((String)"ImageVersion").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Version", (Object)this.version()).add("Platform", (Object)this.platformAsString()).add("Owner", (Object)this.owner()).add("DateCreated", (Object)this.dateCreated()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
            case "owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "dateCreated": {
                return Optional.ofNullable(clazz.cast(this.dateCreated()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageVersion, T> g) {
        return obj -> g.apply((ImageVersion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String version;
        private String platform;
        private String owner;
        private String dateCreated;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageVersion model) {
            this.arn(model.arn);
            this.name(model.name);
            this.version(model.version);
            this.platform(model.platform);
            this.owner(model.owner);
            this.dateCreated(model.dateCreated);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getPlatformAsString() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(Platform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final String getDateCreated() {
            return this.dateCreated;
        }

        @Override
        public final Builder dateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final void setDateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
        }

        public ImageVersion build() {
            return new ImageVersion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageVersion> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder version(String var1);

        public Builder platform(String var1);

        public Builder platform(Platform var1);

        public Builder owner(String var1);

        public Builder dateCreated(String var1);
    }
}

