/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteDistributionConfigurationResponse
extends ImagebuilderResponse
implements ToCopyableBuilder<Builder, DeleteDistributionConfigurationResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteDistributionConfigurationResponse.getter(DeleteDistributionConfigurationResponse::requestId)).setter(DeleteDistributionConfigurationResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()}).build();
    private static final SdkField<String> DISTRIBUTION_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteDistributionConfigurationResponse.getter(DeleteDistributionConfigurationResponse::distributionConfigurationArn)).setter(DeleteDistributionConfigurationResponse.setter(Builder::distributionConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributionConfigurationArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, DISTRIBUTION_CONFIGURATION_ARN_FIELD));
    private final String requestIdValue;
    private final String distributionConfigurationArn;

    private DeleteDistributionConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.distributionConfigurationArn = builder.distributionConfigurationArn;
    }

    public String requestId() {
        return this.requestIdValue;
    }

    public String distributionConfigurationArn() {
        return this.distributionConfigurationArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.distributionConfigurationArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDistributionConfigurationResponse)) {
            return false;
        }
        DeleteDistributionConfigurationResponse other = (DeleteDistributionConfigurationResponse)((Object)obj);
        return Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.distributionConfigurationArn(), other.distributionConfigurationArn());
    }

    public String toString() {
        return ToString.builder((String)"DeleteDistributionConfigurationResponse").add("RequestId", (Object)this.requestId()).add("DistributionConfigurationArn", (Object)this.distributionConfigurationArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "distributionConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.distributionConfigurationArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDistributionConfigurationResponse, T> g) {
        return obj -> g.apply((DeleteDistributionConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderResponse.BuilderImpl
    implements Builder {
        private String requestIdValue;
        private String distributionConfigurationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDistributionConfigurationResponse model) {
            super(model);
            this.requestId(model.requestIdValue);
            this.distributionConfigurationArn(model.distributionConfigurationArn);
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        public final String getDistributionConfigurationArn() {
            return this.distributionConfigurationArn;
        }

        @Override
        public final Builder distributionConfigurationArn(String distributionConfigurationArn) {
            this.distributionConfigurationArn = distributionConfigurationArn;
            return this;
        }

        public final void setDistributionConfigurationArn(String distributionConfigurationArn) {
            this.distributionConfigurationArn = distributionConfigurationArn;
        }

        @Override
        public DeleteDistributionConfigurationResponse build() {
            return new DeleteDistributionConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ImagebuilderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteDistributionConfigurationResponse> {
        public Builder requestId(String var1);

        public Builder distributionConfigurationArn(String var1);
    }
}

