/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.proxy;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class TestProxySetting {
    private Integer port = 0;
    private String host;
    private String userName;
    private String password;
    private Set<String> nonProxyHosts = new HashSet<String>();

    public String toString() {
        return "TestProxySetting{port=" + this.port + ", host='" + this.host + '\'' + ", userName='" + this.userName + '\'' + ", password='" + this.password + '\'' + ", nonProxyHosts=" + this.nonProxyHosts + '}';
    }

    public Integer getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public Set<String> getNonProxyHosts() {
        return Collections.unmodifiableSet(this.nonProxyHosts);
    }

    public TestProxySetting port(Integer port) {
        this.port = port;
        return this;
    }

    public TestProxySetting host(String host) {
        this.host = host;
        return this;
    }

    public TestProxySetting userName(String userName) {
        this.userName = userName;
        return this;
    }

    public TestProxySetting password(String password) {
        this.password = password;
        return this;
    }

    public TestProxySetting nonProxyHost(String ... nonProxyHosts) {
        this.nonProxyHosts = nonProxyHosts != null ? Arrays.stream(nonProxyHosts).collect(Collectors.toSet()) : new HashSet<String>();
        return this;
    }
}

