/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.proxy;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.http.EmptyPublisher;
import software.amazon.awssdk.http.ExecutableHttpRequest;
import software.amazon.awssdk.http.HttpExecuteRequest;
import software.amazon.awssdk.http.HttpExecuteResponse;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.http.async.AsyncExecuteRequest;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpResponseHandler;
import software.amazon.awssdk.http.async.SdkHttpContentPublisher;
import software.amazon.awssdk.testutils.EnvironmentVariableHelper;
import software.amazon.awssdk.utils.Pair;

public abstract class HttpClientDefaultProxyConfigTestSuite {
    private static final EnvironmentVariableHelper ENVIRONMENT_VARIABLE_HELPER = new EnvironmentVariableHelper();
    SecureRandom random = new SecureRandom();
    WireMockServer mockProxy = new WireMockServer((Options)new WireMockConfiguration().dynamicPort().dynamicHttpsPort().enableBrowserProxying(true));
    WireMockServer mockServer = new WireMockServer((Options)new WireMockConfiguration().dynamicPort().dynamicHttpsPort());

    protected abstract boolean isSyncClient();

    protected abstract SdkAsyncHttpClient createHttpClientWithDefaultProxy();

    protected abstract SdkHttpClient createSyncHttpClientWithDefaultProxy();

    protected abstract Class<? extends Exception> getProxyFailedExceptionType();

    protected abstract Class<? extends Exception> getProxyFailedCauseExceptionType();

    @BeforeEach
    public void setup() {
        System.clearProperty("http.proxyHost");
        System.clearProperty("http.proxyPort");
        System.clearProperty("https.proxyHost");
        System.clearProperty("https.proxyPort");
        System.clearProperty("http.nonProxyHosts");
        System.clearProperty("https.nonProxyHosts");
        System.clearProperty("https.proxyPort");
        this.mockProxy.start();
        this.mockServer.start();
        this.mockServer.stubFor(WireMock.get((UrlPattern)WireMock.urlMatching((String)".*")).willReturn(WireMock.aResponse().withStatus(200).withBody("hello")));
    }

    @AfterEach
    public void teardown() {
        this.mockServer.stop();
        this.mockProxy.stop();
        ENVIRONMENT_VARIABLE_HELPER.reset();
    }

    public static Stream<Arguments> proxyConfigurationSettingsForEnvironmentAndSystemProperty() {
        return Stream.of(Arguments.of((Object[])new Object[]{new TestData().addSystemProperKeyValue("http.proxyHost", "localhost").addSystemProperKeyValue("http.proxyPort", "%s").addEnvironmentPropertyProperKeyValue("https_proxy", "http://localhost:%s/"), "Provided system and environment variable when configured uses proxy config"}), Arguments.of((Object[])new Object[]{new TestData().addSystemProperKeyValue("http.proxyHost", "localhost").addSystemProperKeyValue("http.proxyPort", "%s").addEnvironmentPropertyProperKeyValue("none", "none"), "Provided system  and No environment variables uses proxy config"}), Arguments.of((Object[])new Object[]{new TestData().addSystemProperKeyValue("none", "none").addEnvironmentPropertyProperKeyValue("http_proxy", "http://localhost:%s"), "Provided Environment Variables  and No system variables uses proxy config"}));
    }

    @ParameterizedTest(name="{index} - {1}.")
    @MethodSource(value={"proxyConfigurationSettingsForEnvironmentAndSystemProperty"})
    public void ensureProxyErrorsWhenIncorrectPortUsed(TestData testData, String testCaseName) throws Throwable {
        this.setSystemPropertyAndEnvironmentVariables(testData, this.getRandomPort(this.mockProxy.port()));
        if (this.isSyncClient()) {
            SdkHttpClient syncHttpClientWithDefaultProxy = this.createSyncHttpClientWithDefaultProxy();
            this.defaultProxyConfigurationSyncHttp(syncHttpClientWithDefaultProxy, this.getProxyFailedExceptionType(), this.getProxyFailedCauseExceptionType());
            syncHttpClientWithDefaultProxy.close();
        } else {
            SdkAsyncHttpClient httpClientWithDefaultProxy = this.createHttpClientWithDefaultProxy();
            this.defaultProxyConfigurationForAsyncHttp(httpClientWithDefaultProxy, this.getProxyFailedExceptionType(), this.getProxyFailedCauseExceptionType());
            httpClientWithDefaultProxy.close();
        }
    }

    private void setSystemPropertyAndEnvironmentVariablesToDivertToHttpsProxy(TestData testData, int port) {
        testData.systemPropertyPair.stream().map(r -> this.isSyncClient() ? r : Pair.of((Object)((String)r.left()).replace("http", "https"), (Object)((String)r.right()).replace("http", "https"))).forEach(settingsPair -> System.setProperty((String)settingsPair.left(), String.format((String)settingsPair.right(), port)));
        testData.envSystemSetting.stream().map(r -> this.isSyncClient() ? r : Pair.of((Object)((String)r.left()).replace("http", "https"), (Object)((String)r.right()).replace("http", "https"))).forEach(settingsPair -> ENVIRONMENT_VARIABLE_HELPER.set((String)settingsPair.left(), String.format((String)settingsPair.right(), port)));
    }

    private void setSystemPropertyAndEnvironmentVariables(TestData testData, int port) {
        testData.systemPropertyPair.forEach(settingsPair -> System.setProperty((String)settingsPair.left(), String.format((String)settingsPair.right(), port)));
        testData.envSystemSetting.forEach(settingsPair -> ENVIRONMENT_VARIABLE_HELPER.set((String)settingsPair.left(), String.format((String)settingsPair.right(), port)));
    }

    @ParameterizedTest(name="{index} - {1}.")
    @MethodSource(value={"proxyConfigurationSettingsForEnvironmentAndSystemProperty"})
    public void ensureHttpCallsPassesWhenProxyWithCorrectPortIsUsed(TestData testData, String testCaseName) throws Throwable {
        this.setSystemPropertyAndEnvironmentVariablesToDivertToHttpsProxy(testData, this.mockProxy.port());
        if (this.isSyncClient()) {
            SdkHttpClient syncHttpClientWithDefaultProxy = this.createSyncHttpClientWithDefaultProxy();
            this.defaultProxyConfigurationSyncHttp(syncHttpClientWithDefaultProxy, null, null);
            syncHttpClientWithDefaultProxy.close();
        } else {
            SdkAsyncHttpClient asyncHttpClient = this.createHttpClientWithDefaultProxy();
            this.defaultProxyConfigurationForAsyncHttp(asyncHttpClient, null, null);
            asyncHttpClient.close();
        }
    }

    @Test
    public void ensureHttpCallsPassesWhenProxyIsNotUsed() throws Throwable {
        if (this.isSyncClient()) {
            SdkHttpClient sdkHttpClient = this.createSyncHttpClientWithDefaultProxy();
            this.defaultProxyConfigurationSyncHttp(sdkHttpClient, null, null);
            sdkHttpClient.close();
        } else {
            SdkAsyncHttpClient asyncHttpClient = this.createHttpClientWithDefaultProxy();
            this.defaultProxyConfigurationForAsyncHttp(asyncHttpClient, null, null);
            asyncHttpClient.close();
        }
    }

    public void defaultProxyConfigurationForAsyncHttp(SdkAsyncHttpClient client, Class<? extends Exception> proxyFailedExceptionType, Class<? extends Exception> proxyFailedCauseExceptionType) throws Throwable {
        CompletableFuture<Boolean> streamReceived = new CompletableFuture<Boolean>();
        AtomicReference<Object> response = new AtomicReference<Object>(null);
        AtomicReference<Object> error = new AtomicReference<Object>(null);
        Subscriber<ByteBuffer> subscriber = HttpClientDefaultProxyConfigTestSuite.createDummySubscriber();
        SdkAsyncHttpResponseHandler handler = HttpClientDefaultProxyConfigTestSuite.createTestResponseHandler(response, streamReceived, error, subscriber);
        URI uri = URI.create("http://localhost:" + this.mockServer.port());
        SdkHttpFullRequest request = HttpClientDefaultProxyConfigTestSuite.createRequest(uri, "/server/test", null, SdkHttpMethod.GET, Collections.emptyMap());
        CompletableFuture future = client.execute(AsyncExecuteRequest.builder().request((SdkHttpRequest)request).responseHandler(handler).requestContentPublisher((SdkHttpContentPublisher)new EmptyPublisher()).build());
        if (proxyFailedExceptionType != null && proxyFailedCauseExceptionType != null) {
            Assertions.assertThatExceptionOfType(proxyFailedExceptionType).isThrownBy(() -> future.get(60L, TimeUnit.SECONDS)).withCauseInstanceOf(proxyFailedCauseExceptionType);
        } else {
            future.get(60L, TimeUnit.SECONDS);
            Assertions.assertThat((Throwable)error.get()).isNull();
            Assertions.assertThat((Boolean)streamReceived.get(60L, TimeUnit.SECONDS)).isTrue();
            Assertions.assertThat((int)((SdkHttpResponse)response.get()).statusCode()).isEqualTo(200);
        }
    }

    public void defaultProxyConfigurationSyncHttp(SdkHttpClient client, Class<? extends Exception> exceptionType, Class<? extends Exception> proxyFailedCauseExceptionType) throws Throwable {
        CompletableFuture<Boolean> streamReceived = new CompletableFuture<Boolean>();
        AtomicReference<Object> response = new AtomicReference<Object>(null);
        AtomicReference<Object> error = new AtomicReference<Object>(null);
        Subscriber<ByteBuffer> subscriber = HttpClientDefaultProxyConfigTestSuite.createDummySubscriber();
        SdkAsyncHttpResponseHandler handler = HttpClientDefaultProxyConfigTestSuite.createTestResponseHandler(response, streamReceived, error, subscriber);
        URI uri = URI.create("http://localhost:" + this.mockServer.port());
        SdkHttpFullRequest request = HttpClientDefaultProxyConfigTestSuite.createRequest(uri, "/server/test", null, SdkHttpMethod.GET, Collections.emptyMap());
        ExecutableHttpRequest executableHttpRequest = client.prepareRequest(HttpExecuteRequest.builder().request((SdkHttpRequest)request).build());
        if (exceptionType != null) {
            if (proxyFailedCauseExceptionType != null) {
                Assertions.assertThatExceptionOfType(exceptionType).isThrownBy(() -> executableHttpRequest.call()).withCauseInstanceOf(proxyFailedCauseExceptionType);
            } else {
                Assertions.assertThatExceptionOfType(exceptionType).isThrownBy(() -> executableHttpRequest.call());
            }
        } else {
            HttpExecuteResponse executeResponse = executableHttpRequest.call();
            Assertions.assertThat((Throwable)error.get()).isNull();
            Assertions.assertThat((int)executeResponse.httpResponse().statusCode()).isEqualTo(200);
        }
    }

    static Subscriber<ByteBuffer> createDummySubscriber() {
        return new Subscriber<ByteBuffer>(){

            public void onSubscribe(Subscription subscription) {
                subscription.request(Long.MAX_VALUE);
            }

            public void onNext(ByteBuffer byteBuffer) {
            }

            public void onError(Throwable throwable) {
            }

            public void onComplete() {
            }
        };
    }

    static SdkAsyncHttpResponseHandler createTestResponseHandler(final AtomicReference<SdkHttpResponse> response, final CompletableFuture<Boolean> streamReceived, final AtomicReference<Throwable> error, final Subscriber<ByteBuffer> subscriber) {
        return new SdkAsyncHttpResponseHandler(){

            public void onHeaders(SdkHttpResponse headers) {
                response.compareAndSet(null, headers);
            }

            public void onStream(Publisher<ByteBuffer> stream) {
                stream.subscribe(subscriber);
                streamReceived.complete(true);
            }

            public void onError(Throwable t) {
                error.compareAndSet(null, t);
            }
        };
    }

    static SdkHttpFullRequest createRequest(URI endpoint, String resourcePath, byte[] body, SdkHttpMethod method, Map<String, String> params) {
        String contentLength = body == null ? null : String.valueOf(body.length);
        return SdkHttpFullRequest.builder().uri(endpoint).method(method).encodedPath(resourcePath).applyMutation(b -> params.forEach((arg_0, arg_1) -> ((SdkHttpRequest.Builder)b).putRawQueryParameter(arg_0, arg_1))).applyMutation(b -> {
            b.putHeader("Host", endpoint.getHost());
            if (contentLength != null) {
                b.putHeader("Content-Length", contentLength);
            }
        }).build();
    }

    private int getRandomPort(int currentPort) {
        int randomPort;
        while ((randomPort = this.random.nextInt(65535)) == currentPort) {
        }
        return randomPort;
    }

    private static class TestData {
        private List<Pair<String, String>> envSystemSetting = new ArrayList<Pair<String, String>>();
        private List<Pair<String, String>> systemPropertyPair = new ArrayList<Pair<String, String>>();

        private TestData() {
        }

        public TestData addSystemProperKeyValue(String key, String value) {
            this.systemPropertyPair.add((Pair<String, String>)Pair.of((Object)key, (Object)value));
            return this;
        }

        public TestData addEnvironmentPropertyProperKeyValue(String key, String value) {
            this.envSystemSetting.add((Pair<String, String>)Pair.of((Object)key, (Object)value));
            return this;
        }
    }
}

