/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import java.net.URISyntaxException;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import software.amazon.awssdk.http.proxy.ProxyConfigCommonTestData;
import software.amazon.awssdk.http.proxy.TestProxySetting;
import software.amazon.awssdk.testutils.EnvironmentVariableHelper;
import software.amazon.awssdk.utils.Pair;
import software.amazon.awssdk.utils.StringUtils;

public abstract class HttpProxyTestSuite {
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    private static final EnvironmentVariableHelper ENVIRONMENT_VARIABLE_HELPER = new EnvironmentVariableHelper();

    public static Stream<Arguments> proxyConfigurationSetting() {
        return ProxyConfigCommonTestData.proxyConfigurationSetting();
    }

    static void setSystemProperties(List<Pair<String, String>> settingsPairs, String protocol) {
        settingsPairs.stream().filter(p -> StringUtils.isNotBlank((CharSequence)((CharSequence)p.left()))).forEach(settingsPair -> System.setProperty(String.format((String)settingsPair.left(), protocol), (String)settingsPair.right()));
    }

    static void setEnvironmentProperties(List<Pair<String, String>> settingsPairs, String protocol) {
        settingsPairs.forEach(settingsPair -> ENVIRONMENT_VARIABLE_HELPER.set(String.format((String)settingsPair.left(), protocol), (String)settingsPair.right()));
    }

    @BeforeEach
    void setUp() {
        Stream.of(HTTP, HTTPS).forEach(protocol -> Stream.of("%s.proxyHost", "%s.proxyPort", "%s.nonProxyHosts", "%s.proxyUser", "%s.proxyPassword").forEach(property -> System.clearProperty(String.format(property, protocol))));
        ENVIRONMENT_VARIABLE_HELPER.reset();
    }

    @ParameterizedTest(name="{index} -{0}  useSystemProperty {4} useEnvironmentVariable {5}  userSetProxy {3} then expected is {6}")
    @MethodSource(value={"proxyConfigurationSetting"})
    void givenLocalSettingForHttpThenCorrectProxyConfig(String testCaseName, List<Pair<String, String>> systemSettingsPair, List<Pair<String, String>> envSystemSetting, TestProxySetting userSetProxySettings, Boolean useSystemProperty, Boolean useEnvironmentVariable, TestProxySetting expectedProxySettings) throws URISyntaxException {
        HttpProxyTestSuite.setSystemProperties(systemSettingsPair, HTTP);
        HttpProxyTestSuite.setEnvironmentProperties(envSystemSetting, HTTP);
        this.assertProxyConfiguration(userSetProxySettings, expectedProxySettings, useSystemProperty, useEnvironmentVariable, HTTP);
    }

    @ParameterizedTest(name="{index} -{0}  useSystemProperty {4} useEnvironmentVariable {5}  userSetProxy {3} then expected is {6}")
    @MethodSource(value={"proxyConfigurationSetting"})
    void givenLocalSettingForHttpsThenCorrectProxyConfig(String testCaseName, List<Pair<String, String>> systemSettingsPair, List<Pair<String, String>> envSystemSetting, TestProxySetting userSetProxySettings, Boolean useSystemProperty, Boolean useEnvironmentVariable, TestProxySetting expectedProxySettings) throws URISyntaxException {
        HttpProxyTestSuite.setSystemProperties(systemSettingsPair, HTTPS);
        HttpProxyTestSuite.setEnvironmentProperties(envSystemSetting, HTTPS);
        this.assertProxyConfiguration(userSetProxySettings, expectedProxySettings, useSystemProperty, useEnvironmentVariable, HTTPS);
    }

    protected abstract void assertProxyConfiguration(TestProxySetting var1, TestProxySetting var2, Boolean var3, Boolean var4, String var5) throws URISyntaxException;
}

