/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.proxy;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import org.junit.jupiter.params.provider.Arguments;
import software.amazon.awssdk.http.proxy.TestProxySetting;
import software.amazon.awssdk.utils.Pair;

public final class ProxyConfigCommonTestData {
    public static final String SYSTEM_PROPERTY_HOST = "systemProperty.com";
    public static final String SYSTEM_PROPERTY_PORT_NUMBER = "2222";
    public static final String SYSTEM_PROPERTY_NON_PROXY = "systemPropertyNonProxy.com".toLowerCase(Locale.US);
    public static final String SYSTEM_PROPERTY_USER = "systemPropertyUserOne";
    public static final String SYSTEM_PROPERTY_PASSWORD = "systemPropertyPassword";
    public static final String ENV_VARIABLE_USER = "envUserOne";
    public static final String ENV_VARIABLE_PASSWORD = "envPassword";
    public static final String ENVIRONMENT_HOST = "environmentVariable.com".toLowerCase(Locale.US);
    public static final String ENVIRONMENT_VARIABLE_PORT_NUMBER = "3333";
    public static final String ENVIRONMENT_VARIABLE_NON_PROXY = "environmentVariableNonProxy".toLowerCase(Locale.US);
    public static final String USER_HOST_ON_BUILDER = "proxyBuilder.com";
    public static final int USER_PORT_NUMBER_ON_BUILDER = 9999;
    public static final String USER_USERNAME_ON_BUILDER = "proxyBuilderUser";
    public static final String USER_PASSWORD_ON_BUILDER = "proxyBuilderPassword";
    public static final String USER_NONPROXY_ON_BUILDER = "proxyBuilderNonProxy.com".toLowerCase(Locale.US);

    private ProxyConfigCommonTestData() {
    }

    public static Stream<Arguments> proxyConfigurationSetting() {
        return Stream.of(Arguments.of((Object[])new Object[]{"Provided system and environment variable when configured default setting then uses System property", ProxyConfigCommonTestData.systemPropertySettings(), ProxyConfigCommonTestData.environmentSettings(), new TestProxySetting(), null, null, ProxyConfigCommonTestData.getSystemPropertyProxySettings()}), Arguments.of((Object[])new Object[]{"Provided system and environment variable when Host and port used from Builder then resolved Poxy config uses User password from System setting", ProxyConfigCommonTestData.systemPropertySettings(), ProxyConfigCommonTestData.environmentSettings(), new TestProxySetting().host("localhost").port(80), null, null, ProxyConfigCommonTestData.getSystemPropertyProxySettings().host("localhost").port(80)}), Arguments.of((Object[])new Object[]{"Provided system and environment variable when configured user setting then uses User provider setting", ProxyConfigCommonTestData.systemPropertySettings(), ProxyConfigCommonTestData.environmentSettings(), ProxyConfigCommonTestData.getTestProxySettings(), null, null, ProxyConfigCommonTestData.getTestProxySettings()}), Arguments.of((Object[])new Object[]{"Provided: System property settings and environment variables are set. When: useEnvironmentVariable is set to \true. And: useSystemProperty is left at its default value. Then: The proxy configuration gets resolved to use system properties ", ProxyConfigCommonTestData.systemPropertySettings(), ProxyConfigCommonTestData.environmentSettings(), new TestProxySetting(), null, true, ProxyConfigCommonTestData.getSystemPropertyProxySettings()}), Arguments.of((Object[])new Object[]{"Provided: System property settings and environment variables are set. When: useEnvironmentVariable is set to true. And: useSystemProperty is set to false. Then: The proxy configuration gets resolved to use environment variable values", ProxyConfigCommonTestData.systemPropertySettings(), ProxyConfigCommonTestData.environmentSettings(), new TestProxySetting(), false, true, ProxyConfigCommonTestData.getEnvironmentVariableProxySettings()}), Arguments.of((Object[])new Object[]{"Provided with no system property and valid environment variables, when using the default proxy builder, the proxy configuration is resolved to use environment variables.", Collections.singletonList(Pair.of((Object)"", (Object)"")), ProxyConfigCommonTestData.environmentSettings(), new TestProxySetting(), null, null, ProxyConfigCommonTestData.getEnvironmentVariableProxySettings()}), Arguments.of((Object[])new Object[]{"Provided with no system property and valid environment variables, when using the host,port on builder , the proxy configuration is resolved to username and password of environment variables.", Collections.singletonList(Pair.of((Object)"", (Object)"")), ProxyConfigCommonTestData.environmentSettings(), new TestProxySetting().host(USER_HOST_ON_BUILDER).port(9999), null, true, ProxyConfigCommonTestData.getEnvironmentVariableProxySettings().host(USER_HOST_ON_BUILDER).port(9999)}), Arguments.of((Object[])new Object[]{"Provided with no system property and valid environment variables, when using the host,port on builder , the proxy configuration is resolved to Builder values.", Collections.singletonList(Pair.of((Object)"", (Object)"")), ProxyConfigCommonTestData.environmentSettings(), ProxyConfigCommonTestData.getTestProxySettings(), null, null, ProxyConfigCommonTestData.getTestProxySettings()}), Arguments.of((Object[])new Object[]{"Provided environment variable and No System Property when default ProxyConfig then uses environment variable ", Collections.singletonList(Pair.of((Object)"", (Object)"")), ProxyConfigCommonTestData.environmentSettings(), new TestProxySetting(), null, true, ProxyConfigCommonTestData.getEnvironmentVariableProxySettings()}), Arguments.of((Object[])new Object[]{"Provided only environment variable when useSytemProperty set to true then proxy resolved to environment", Collections.singletonList(Pair.of((Object)"", (Object)"")), ProxyConfigCommonTestData.environmentSettings(), null, true, null, ProxyConfigCommonTestData.getEnvironmentVariableProxySettings()}), Arguments.of((Object[])new Object[]{"Provided only environment variable when useEnvironmentVariable set to false then proxy resolved to null", Collections.singletonList(Pair.of((Object)"", (Object)"")), ProxyConfigCommonTestData.environmentSettings(), new TestProxySetting(), null, true, ProxyConfigCommonTestData.getEnvironmentVariableProxySettings()}), Arguments.of((Object[])new Object[]{"Provided system and no environment variable when default ProxyConfig then used System Proxy config", ProxyConfigCommonTestData.systemPropertySettings(), Collections.singletonList(Pair.of((Object)"", (Object)"")), null, null, null, ProxyConfigCommonTestData.getSystemPropertyProxySettings()}), Arguments.of((Object[])new Object[]{"Provided system and no environment variable when host from builder then Host is resolved from builder", ProxyConfigCommonTestData.systemPropertySettings(), Collections.singletonList(Pair.of((Object)"", (Object)"")), new TestProxySetting().port(9999).host(USER_HOST_ON_BUILDER), null, null, ProxyConfigCommonTestData.getSystemPropertyProxySettings().host(USER_HOST_ON_BUILDER).port(9999)}), Arguments.of((Object[])new Object[]{"Provided system and no environment variable when user ProxyConfig on builder then  User Proxy resolved", ProxyConfigCommonTestData.systemPropertySettings(), Collections.singletonList(Pair.of((Object)"", (Object)"")), ProxyConfigCommonTestData.getTestProxySettings(), true, true, ProxyConfigCommonTestData.getTestProxySettings()}), Arguments.of((Object[])new Object[]{"Provided system and no environment variable when useEnvironmentVariable then System property proxy resolved", ProxyConfigCommonTestData.systemPropertySettings(), Collections.singletonList(Pair.of((Object)"", (Object)"")), new TestProxySetting(), null, true, ProxyConfigCommonTestData.getSystemPropertyProxySettings()}), Arguments.of((Object[])new Object[]{"Provided system and no environment variable when useSystemProperty and useEnvironment set to false then resolved config is null ", ProxyConfigCommonTestData.systemPropertySettings(), Collections.singletonList(Pair.of((Object)"", (Object)"")), new TestProxySetting(), false, true, new TestProxySetting()}), Arguments.of((Object[])new Object[]{"Provided  no system property and no environment variable when default ProxyConfig then no Proxy config resolved", Collections.singletonList(Pair.of((Object)"", (Object)"")), Collections.singletonList(Pair.of((Object)"", (Object)"")), new TestProxySetting(), null, null, new TestProxySetting()}), Arguments.of((Object[])new Object[]{"Provided  no system property and no environment variable when user ProxyConfig then user Proxy config resolved", Collections.singletonList(Pair.of((Object)"", (Object)"")), Collections.singletonList(Pair.of((Object)"", (Object)"")), new TestProxySetting().host(USER_HOST_ON_BUILDER).port(9999), null, null, new TestProxySetting().host(USER_HOST_ON_BUILDER).port(9999)}), Arguments.of((Object[])new Object[]{"Provided  no system property and no environment variable when user ProxyConfig then user Proxy config resolved", Collections.singletonList(Pair.of((Object)"", (Object)"")), Collections.singletonList(Pair.of((Object)"", (Object)"")), ProxyConfigCommonTestData.getTestProxySettings(), null, null, ProxyConfigCommonTestData.getTestProxySettings()}), Arguments.of((Object[])new Object[]{"Provided  no system property and no environment variable when useSystemProperty and useEnvironmentVariable set  then resolved host is null ", Collections.singletonList(Pair.of((Object)"", (Object)"")), Collections.singletonList(Pair.of((Object)"", (Object)"")), null, true, true, new TestProxySetting()}), Arguments.of((Object[])new Object[]{"Given System property with No user name and Environment variable with user name when Default proxy config then resolves proxy config with no user name same as System property", ProxyConfigCommonTestData.getSystemPropertiesWithNoUserName(), ProxyConfigCommonTestData.environmentSettingsWithNoPassword(), new TestProxySetting(), null, null, new TestProxySetting().host(SYSTEM_PROPERTY_HOST).port(Integer.parseInt(SYSTEM_PROPERTY_PORT_NUMBER)).password(SYSTEM_PROPERTY_PASSWORD)}), Arguments.of((Object[])new Object[]{"Given password in System property when Password present in system property then proxy resolves to Builder password", ProxyConfigCommonTestData.getSystemPropertiesWithNoUserName(), ProxyConfigCommonTestData.environmentSettingsWithNoPassword(), new TestProxySetting().password("passwordFromBuilder"), null, null, ProxyConfigCommonTestData.getSystemPropertyProxySettings().password("passwordFromBuilder").userName(null).nonProxyHost(null)}), Arguments.of((Object[])new Object[]{"Given partial System Property and partial Environment variables when Builder method with Host and port only then Proxy config uses password from System property and no User name since System property has none", ProxyConfigCommonTestData.getSystemPropertiesWithNoUserName(), ProxyConfigCommonTestData.environmentSettingsWithNoPassword(), new TestProxySetting().host(USER_HOST_ON_BUILDER).port(9999), null, null, ProxyConfigCommonTestData.getSystemPropertyProxySettings().host(USER_HOST_ON_BUILDER).port(9999).userName(null).nonProxyHost(null)}), Arguments.of((Object[])new Object[]{"Given System Property and Environment variables when valid empty Proxy config on Builder then Proxy config resolves to Proxy on builder.", ProxyConfigCommonTestData.systemPropertySettings(), ProxyConfigCommonTestData.environmentSettings(), ProxyConfigCommonTestData.getTestProxySettings(), null, null, ProxyConfigCommonTestData.getTestProxySettings()}), Arguments.of((Object[])new Object[]{"Given partial system property and partial environment variable when User set useEnvironmentVariable to true and default System property then default system property gets used.", ProxyConfigCommonTestData.getSystemPropertiesWithNoUserName(), ProxyConfigCommonTestData.environmentSettingsWithNoPassword(), new TestProxySetting(), null, true, ProxyConfigCommonTestData.getSystemPropertyProxySettings().nonProxyHost(null).userName(null)}), Arguments.of((Object[])new Object[]{"Given partial system property and partial environment variable  when User set useEnvironmentVariable and explicitly sets useSystemProperty to fals then only environment variable is resolved", ProxyConfigCommonTestData.getSystemPropertiesWithNoUserName(), ProxyConfigCommonTestData.environmentSettingsWithNoPassword(), new TestProxySetting(), false, true, ProxyConfigCommonTestData.getEnvironmentVariableProxySettings().password(null)}));
    }

    private static List<Pair<String, String>> getSystemPropertiesWithNoUserName() {
        return Arrays.asList(Pair.of((Object)"%s.proxyHost", (Object)SYSTEM_PROPERTY_HOST), Pair.of((Object)"%s.proxyPort", (Object)SYSTEM_PROPERTY_PORT_NUMBER), Pair.of((Object)"%s.proxyPassword", (Object)SYSTEM_PROPERTY_PASSWORD));
    }

    private static TestProxySetting getTestProxySettings() {
        return new TestProxySetting().host(USER_HOST_ON_BUILDER).port(9999).userName(USER_USERNAME_ON_BUILDER).password(USER_PASSWORD_ON_BUILDER).nonProxyHost(USER_NONPROXY_ON_BUILDER);
    }

    private static TestProxySetting getSystemPropertyProxySettings() {
        return new TestProxySetting().host(SYSTEM_PROPERTY_HOST).port(Integer.parseInt(SYSTEM_PROPERTY_PORT_NUMBER)).userName(SYSTEM_PROPERTY_USER).password(SYSTEM_PROPERTY_PASSWORD).nonProxyHost(SYSTEM_PROPERTY_NON_PROXY);
    }

    private static TestProxySetting getEnvironmentVariableProxySettings() {
        return new TestProxySetting().host(ENVIRONMENT_HOST).port(Integer.parseInt(ENVIRONMENT_VARIABLE_PORT_NUMBER)).userName(ENV_VARIABLE_USER).password(ENV_VARIABLE_PASSWORD).nonProxyHost(ENVIRONMENT_VARIABLE_NON_PROXY);
    }

    private static List<Pair<String, String>> environmentSettings() {
        return Arrays.asList(Pair.of((Object)"%s_proxy", (Object)("http://envUserOne:envPassword@" + ENVIRONMENT_HOST + ":" + ENVIRONMENT_VARIABLE_PORT_NUMBER + "/")), Pair.of((Object)"no_proxy", (Object)ENVIRONMENT_VARIABLE_NON_PROXY));
    }

    private static List<Pair<String, String>> environmentSettingsWithNoPassword() {
        return Arrays.asList(Pair.of((Object)"%s_proxy", (Object)("http://envUserOne@" + ENVIRONMENT_HOST + ":" + ENVIRONMENT_VARIABLE_PORT_NUMBER + "/")), Pair.of((Object)"no_proxy", (Object)ENVIRONMENT_VARIABLE_NON_PROXY));
    }

    private static List<Pair<String, String>> systemPropertySettings() {
        return Arrays.asList(Pair.of((Object)"%s.proxyHost", (Object)SYSTEM_PROPERTY_HOST), Pair.of((Object)"%s.proxyPort", (Object)SYSTEM_PROPERTY_PORT_NUMBER), Pair.of((Object)"http.nonProxyHosts", (Object)SYSTEM_PROPERTY_NON_PROXY), Pair.of((Object)"%s.proxyUser", (Object)SYSTEM_PROPERTY_USER), Pair.of((Object)"%s.proxyPassword", (Object)SYSTEM_PROPERTY_PASSWORD));
    }
}

