/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import com.github.tomakehurst.wiremock.http.trafficlistener.WiremockNetworkTrafficListener;
import java.io.ByteArrayOutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import software.amazon.awssdk.utils.BinaryUtils;
import software.amazon.awssdk.utils.FunctionalUtils;

public class ConnectionCountingTrafficListener
implements WiremockNetworkTrafficListener {
    private final Map<Socket, ByteArrayOutputStream> sockets = new ConcurrentHashMap<Socket, ByteArrayOutputStream>();

    public void opened(Socket socket) {
        this.sockets.put(socket, new ByteArrayOutputStream());
    }

    public void incoming(Socket socket, ByteBuffer bytes) {
        FunctionalUtils.invokeSafely(() -> this.sockets.get(socket).write(BinaryUtils.copyBytesFrom((ByteBuffer)bytes.asReadOnlyBuffer())));
    }

    public void outgoing(Socket socket, ByteBuffer bytes) {
    }

    public void closed(Socket socket) {
    }

    public int openedConnections() {
        int count = 0;
        for (ByteArrayOutputStream data : this.sockets.values()) {
            byte[] bytes = data.toByteArray();
            try {
                if (new String(bytes, StandardCharsets.UTF_8).startsWith("POST /__admin/mappings")) continue;
                ++count;
            }
            catch (RuntimeException e) {
                ++count;
            }
        }
        return count;
    }
}

