/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.FatalStartupException;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.trafficlistener.WiremockNetworkTrafficListener;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.http.ExecutableHttpRequest;
import software.amazon.awssdk.http.HttpExecuteRequest;
import software.amazon.awssdk.http.HttpExecuteResponse;
import software.amazon.awssdk.http.HttpTestUtils;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.TlsTrustManagersProvider;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.Logger;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class SdkHttpClientTestSuite {
    private static final Logger LOG = Logger.loggerFor(SdkHttpClientTestSuite.class);
    private static final ConnectionCountingTrafficListener CONNECTION_COUNTER = new ConnectionCountingTrafficListener();
    @Rule
    public WireMockRule mockServer = this.createWireMockRule();
    private final Random rng = new Random();

    @Test
    public void supportsResponseCode200() throws Exception {
        this.testForResponseCode(200);
    }

    @Test
    public void supportsResponseCode200Head() throws Exception {
        this.testForResponseCode(403, SdkHttpMethod.HEAD);
    }

    @Test
    public void supportsResponseCode202() throws Exception {
        this.testForResponseCode(202);
    }

    @Test
    public void supportsResponseCode403() throws Exception {
        this.testForResponseCode(403);
    }

    @Test
    public void supportsResponseCode403Head() throws Exception {
        this.testForResponseCode(403, SdkHttpMethod.HEAD);
    }

    @Test
    public void supportsResponseCode301() throws Exception {
        this.testForResponseCode(301);
    }

    @Test
    public void supportsResponseCode302() throws Exception {
        this.testForResponseCode(302);
    }

    @Test
    public void supportsResponseCode500() throws Exception {
        this.testForResponseCode(500);
    }

    @Test
    public void validatesHttpsCertificateIssuer() throws Exception {
        SdkHttpClient client = this.createSdkHttpClient();
        SdkHttpFullRequest request = this.mockSdkRequest("https://localhost:" + this.mockServer.httpsPort(), SdkHttpMethod.POST);
        Assertions.assertThatThrownBy(() -> ((ExecutableHttpRequest)client.prepareRequest(HttpExecuteRequest.builder().request((SdkHttpRequest)request).build())).call()).isInstanceOf(SSLHandshakeException.class);
    }

    @Test
    public void connectionPoolingWorks() throws Exception {
        int initialOpenedConnections = CONNECTION_COUNTER.openedConnections();
        SdkHttpClientOptions httpClientOptions = new SdkHttpClientOptions();
        httpClientOptions.trustAll(true);
        SdkHttpClient client = this.createSdkHttpClient(httpClientOptions);
        this.stubForMockRequest(200);
        for (int i = 0; i < 5; ++i) {
            SdkHttpFullRequest req = this.mockSdkRequest("http://localhost:" + this.mockServer.port(), SdkHttpMethod.POST);
            HttpExecuteResponse response = client.prepareRequest(HttpExecuteRequest.builder().request((SdkHttpRequest)req).contentStreamProvider((ContentStreamProvider)req.contentStreamProvider().orElse(null)).build()).call();
            response.responseBody().ifPresent(IoUtils::drainInputStream);
        }
        Assertions.assertThat((int)CONNECTION_COUNTER.openedConnections()).isEqualTo(initialOpenedConnections + 1);
    }

    @Test
    public void connectionsAreNotReusedOn5xxErrors() throws Exception {
        int initialOpenedConnections = CONNECTION_COUNTER.openedConnections();
        SdkHttpClientOptions httpClientOptions = new SdkHttpClientOptions();
        httpClientOptions.trustAll(true);
        SdkHttpClient client = this.createSdkHttpClient(httpClientOptions);
        this.stubForMockRequest(503);
        for (int i = 0; i < 5; ++i) {
            SdkHttpFullRequest req = this.mockSdkRequest("http://localhost:" + this.mockServer.port(), SdkHttpMethod.POST);
            HttpExecuteResponse response = client.prepareRequest(HttpExecuteRequest.builder().request((SdkHttpRequest)req).contentStreamProvider((ContentStreamProvider)req.contentStreamProvider().orElse(null)).build()).call();
            response.responseBody().ifPresent(IoUtils::drainInputStream);
        }
        Assertions.assertThat((int)CONNECTION_COUNTER.openedConnections()).isEqualTo(initialOpenedConnections + 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomTlsTrustManager() throws Exception {
        WireMockServer selfSignedServer = HttpTestUtils.createSelfSignedServer();
        TrustManagerFactory managerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        managerFactory.init(HttpTestUtils.getSelfSignedKeyStore());
        SdkHttpClientOptions httpClientOptions = new SdkHttpClientOptions();
        httpClientOptions.tlsTrustManagersProvider(managerFactory::getTrustManagers);
        selfSignedServer.start();
        try {
            SdkHttpClient client = this.createSdkHttpClient(httpClientOptions);
            SdkHttpFullRequest request = this.mockSdkRequest("https://localhost:" + selfSignedServer.httpsPort(), SdkHttpMethod.POST);
            client.prepareRequest(HttpExecuteRequest.builder().request((SdkHttpRequest)request).build()).call();
        }
        finally {
            selfSignedServer.stop();
        }
    }

    @Test
    public void testTrustAllWorks() throws Exception {
        SdkHttpClientOptions httpClientOptions = new SdkHttpClientOptions();
        httpClientOptions.trustAll(true);
        this.testForResponseCodeUsingHttps(this.createSdkHttpClient(httpClientOptions), 200);
    }

    @Test
    public void testCustomTlsTrustManagerAndTrustAllFails() throws Exception {
        SdkHttpClientOptions httpClientOptions = new SdkHttpClientOptions();
        httpClientOptions.tlsTrustManagersProvider(() -> new TrustManager[0]);
        httpClientOptions.trustAll(true);
        Assertions.assertThatThrownBy(() -> this.createSdkHttpClient(httpClientOptions)).isInstanceOf(IllegalArgumentException.class);
    }

    protected void testForResponseCode(int returnCode) throws Exception {
        this.testForResponseCode(returnCode, SdkHttpMethod.POST);
    }

    private void testForResponseCode(int returnCode, SdkHttpMethod method) throws Exception {
        SdkHttpClient client = this.createSdkHttpClient();
        this.stubForMockRequest(returnCode);
        SdkHttpFullRequest req = this.mockSdkRequest("http://localhost:" + this.mockServer.port(), method);
        HttpExecuteResponse rsp = client.prepareRequest(HttpExecuteRequest.builder().request((SdkHttpRequest)req).contentStreamProvider((ContentStreamProvider)req.contentStreamProvider().orElse(null)).build()).call();
        this.validateResponse(rsp, returnCode, method);
    }

    protected void testForResponseCodeUsingHttps(SdkHttpClient client, int returnCode) throws Exception {
        SdkHttpMethod sdkHttpMethod = SdkHttpMethod.POST;
        this.stubForMockRequest(returnCode);
        SdkHttpFullRequest req = this.mockSdkRequest("https://localhost:" + this.mockServer.httpsPort(), sdkHttpMethod);
        HttpExecuteResponse rsp = client.prepareRequest(HttpExecuteRequest.builder().request((SdkHttpRequest)req).contentStreamProvider((ContentStreamProvider)req.contentStreamProvider().orElse(null)).build()).call();
        this.validateResponse(rsp, returnCode, sdkHttpMethod);
    }

    private void stubForMockRequest(int returnCode) {
        ResponseDefinitionBuilder responseBuilder = WireMock.aResponse().withStatus(returnCode).withHeader("Some-Header", new String[]{"With Value"}).withBody("hello");
        if (returnCode >= 300 && returnCode <= 399) {
            responseBuilder.withHeader("Location", new String[]{"Some New Location"});
        }
        this.mockServer.stubFor(WireMock.any((UrlPattern)WireMock.urlPathEqualTo((String)"/")).willReturn(responseBuilder));
    }

    private void validateResponse(HttpExecuteResponse response, int returnCode, SdkHttpMethod method) throws IOException {
        RequestMethod requestMethod = RequestMethod.fromString((String)method.name());
        RequestPatternBuilder patternBuilder = RequestPatternBuilder.newRequestPattern((RequestMethod)requestMethod, (UrlPattern)WireMock.urlMatching((String)"/")).withHeader("Host", WireMock.containing((String)"localhost")).withHeader("User-Agent", WireMock.equalTo((String)"hello-world!"));
        if (method == SdkHttpMethod.HEAD) {
            patternBuilder.withRequestBody((ContentPattern)WireMock.equalTo((String)""));
        } else {
            patternBuilder.withRequestBody((ContentPattern)WireMock.equalTo((String)"Body"));
        }
        this.mockServer.verify(1, patternBuilder);
        if (method == SdkHttpMethod.HEAD) {
            Assertions.assertThat((Optional)response.responseBody()).isEmpty();
        } else {
            Assertions.assertThat((String)IoUtils.toUtf8String((InputStream)response.responseBody().orElse(null))).isEqualTo("hello");
        }
        Assertions.assertThat((Optional)response.httpResponse().firstMatchingHeader("Some-Header")).contains((Object)"With Value");
        Assertions.assertThat((int)response.httpResponse().statusCode()).isEqualTo(returnCode);
        this.mockServer.resetMappings();
    }

    private SdkHttpFullRequest mockSdkRequest(String uriString, SdkHttpMethod method) {
        URI uri = URI.create(uriString);
        SdkHttpFullRequest.Builder requestBuilder = SdkHttpFullRequest.builder().uri(uri).method(method).putHeader("Host", uri.getHost()).putHeader("User-Agent", "hello-world!");
        if (method != SdkHttpMethod.HEAD) {
            requestBuilder.contentStreamProvider(() -> new ByteArrayInputStream("Body".getBytes(StandardCharsets.UTF_8)));
        }
        return requestBuilder.build();
    }

    protected final SdkHttpClient createSdkHttpClient() {
        return this.createSdkHttpClient(new SdkHttpClientOptions());
    }

    protected abstract SdkHttpClient createSdkHttpClient(SdkHttpClientOptions var1);

    private WireMockRule createWireMockRule() {
        int maxAttempts = 5;
        for (int i = 0; i < maxAttempts; ++i) {
            try {
                return new WireMockRule((Options)WireMockConfiguration.wireMockConfig().dynamicPort().dynamicHttpsPort().networkTrafficListener((WiremockNetworkTrafficListener)CONNECTION_COUNTER));
            }
            catch (FatalStartupException e) {
                int attemptNum = i + 1;
                LOG.debug(() -> "Was not able to start WireMock server. Attempt " + attemptNum, (Throwable)e);
                if (attemptNum == maxAttempts) continue;
                try {
                    long sleepMillis = 1000L + (long)this.rng.nextInt(1000);
                    Thread.sleep(sleepMillis);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Backoff interrupted", ie);
                }
            }
        }
        throw new RuntimeException("Unable to setup WireMock rule");
    }

    private static class ConnectionCountingTrafficListener
    implements WiremockNetworkTrafficListener {
        private final AtomicInteger openedConnections = new AtomicInteger(0);

        private ConnectionCountingTrafficListener() {
        }

        public void opened(Socket socket) {
            this.openedConnections.incrementAndGet();
        }

        public void incoming(Socket socket, ByteBuffer bytes) {
        }

        public void outgoing(Socket socket, ByteBuffer bytes) {
        }

        public void closed(Socket socket) {
        }

        public int openedConnections() {
            return this.openedConnections.get();
        }
    }

    protected static final class SdkHttpClientOptions {
        private TlsTrustManagersProvider tlsTrustManagersProvider = null;
        private boolean trustAll = false;

        protected SdkHttpClientOptions() {
        }

        public TlsTrustManagersProvider tlsTrustManagersProvider() {
            return this.tlsTrustManagersProvider;
        }

        public void tlsTrustManagersProvider(TlsTrustManagersProvider tlsTrustManagersProvider) {
            this.tlsTrustManagersProvider = tlsTrustManagersProvider;
        }

        public boolean trustAll() {
            return this.trustAll;
        }

        public void trustAll(boolean trustAll) {
            this.trustAll = trustAll;
        }
    }
}

