/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import io.reactivex.Flowable;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.http.EmptyPublisher;
import software.amazon.awssdk.http.SdkHttpClientTestSuite;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.http.async.AsyncExecuteRequest;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpResponseHandler;
import software.amazon.awssdk.http.async.SdkHttpContentPublisher;
import software.amazon.awssdk.utils.StringUtils;

public class HttpTestUtils {
    private HttpTestUtils() {
    }

    public static WireMockServer createSelfSignedServer() {
        URL selfSignedJks = SdkHttpClientTestSuite.class.getResource("/selfSigned.jks");
        return new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicHttpsPort().keystorePath(selfSignedJks.toString()).keystorePassword("changeit").keystoreType("jks"));
    }

    public static KeyStore getSelfSignedKeyStore() throws Exception {
        URL selfSignedJks = SdkHttpClientTestSuite.class.getResource("/selfSigned.jks");
        KeyStore keyStore = KeyStore.getInstance("jks");
        try (InputStream stream = selfSignedJks.openStream();){
            keyStore.load(stream, "changeit".toCharArray());
        }
        return keyStore;
    }

    public static CompletableFuture<Void> sendGetRequest(int serverPort, SdkAsyncHttpClient client) {
        AsyncExecuteRequest req = AsyncExecuteRequest.builder().responseHandler(new SdkAsyncHttpResponseHandler(){
            private SdkHttpResponse headers;

            public void onHeaders(SdkHttpResponse headers) {
                this.headers = headers;
            }

            public void onStream(Publisher<ByteBuffer> stream) {
                Flowable.fromPublisher(stream).forEach(b -> {});
            }

            public void onError(Throwable error) {
            }
        }).request((SdkHttpRequest)SdkHttpFullRequest.builder().method(SdkHttpMethod.GET).protocol("https").host("127.0.0.1").port(Integer.valueOf(serverPort)).build()).requestContentPublisher((SdkHttpContentPublisher)new EmptyPublisher()).build();
        return client.execute(req);
    }

    public static SdkHttpContentPublisher createProvider(final String body) {
        final Stream<ByteBuffer> chunks = HttpTestUtils.splitStringBySize(body).stream().map(chunk -> ByteBuffer.wrap(chunk.getBytes(StandardCharsets.UTF_8)));
        return new SdkHttpContentPublisher(){

            public Optional<Long> contentLength() {
                return Optional.of(Long.valueOf(body.length()));
            }

            public void subscribe(final Subscriber<? super ByteBuffer> s) {
                s.onSubscribe(new Subscription(){

                    public void request(long n) {
                        chunks.forEach(arg_0 -> ((Subscriber)s).onNext(arg_0));
                        s.onComplete();
                    }

                    public void cancel() {
                    }
                });
            }
        };
    }

    public static Collection<String> splitStringBySize(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return Collections.emptyList();
        }
        ArrayList<String> split = new ArrayList<String>();
        for (int i = 0; i <= str.length() / 1000; ++i) {
            split.add(str.substring(i * 1000, Math.min((i + 1) * 1000, str.length())));
        }
        return split;
    }
}

