/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import software.amazon.awssdk.http.SdkHttpClientTestSuite;

public class HttpTestUtils {
    private HttpTestUtils() {
    }

    public static WireMockServer createSelfSignedServer() {
        URL selfSignedJks = SdkHttpClientTestSuite.class.getResource("/selfSigned.jks");
        return new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicHttpsPort().keystorePath(selfSignedJks.toString()).keystorePassword("changeit").keystoreType("jks"));
    }

    public static KeyStore getSelfSignedKeyStore() throws Exception {
        URL selfSignedJks = SdkHttpClientTestSuite.class.getResource("/selfSigned.jks");
        KeyStore keyStore = KeyStore.getInstance("jks");
        try (InputStream stream = selfSignedJks.openStream();){
            keyStore.load(stream, "changeit".toCharArray());
        }
        return keyStore;
    }
}

