/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.net.ssl.SSLHandshakeException;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.http.ExecutableHttpRequest;
import software.amazon.awssdk.http.HttpExecuteRequest;
import software.amazon.awssdk.http.HttpExecuteResponse;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.SdkRequestContext;
import software.amazon.awssdk.utils.IoUtils;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class SdkHttpClientTestSuite {
    @Rule
    public WireMockRule mockServer = new WireMockRule((Options)WireMockConfiguration.wireMockConfig().dynamicPort().dynamicHttpsPort());
    @Mock
    private SdkRequestContext requestContext;

    @Test
    public void supportsResponseCode200() throws Exception {
        this.testForResponseCode(200);
    }

    @Test
    public void supportsResponseCode202() throws Exception {
        this.testForResponseCode(202);
    }

    @Test
    public void supportsResponseCode403() throws Exception {
        this.testForResponseCode(403);
    }

    @Test
    public void supportsResponseCode301() throws Exception {
        this.testForResponseCode(301);
    }

    @Test
    public void supportsResponseCode302() throws Exception {
        this.testForResponseCode(302);
    }

    @Test
    public void supportsResponseCode500() throws Exception {
        this.testForResponseCode(500);
    }

    @Test
    public void validatesHttpsCertificateIssuer() throws Exception {
        SdkHttpClient client = this.createSdkHttpClient();
        SdkHttpFullRequest request = this.mockSdkRequest("https://localhost:" + this.mockServer.httpsPort());
        Assertions.assertThatThrownBy(() -> ((ExecutableHttpRequest)client.prepareRequest(HttpExecuteRequest.builder().request((SdkHttpRequest)request).build())).call()).isInstanceOf(SSLHandshakeException.class);
    }

    private void testForResponseCode(int returnCode) throws Exception {
        SdkHttpClient client = this.createSdkHttpClient();
        this.stubForMockRequest(returnCode);
        SdkHttpFullRequest request = this.mockSdkRequest("http://localhost:" + this.mockServer.port());
        HttpExecuteResponse response = client.prepareRequest(HttpExecuteRequest.builder().request((SdkHttpRequest)request).contentStreamProvider((ContentStreamProvider)request.contentStreamProvider().get()).build()).call();
        this.validateResponse(response, returnCode);
    }

    protected void testForResponseCodeUsingHttps(SdkHttpClient client, int returnCode) throws Exception {
        this.stubForMockRequest(returnCode);
        SdkHttpFullRequest request = this.mockSdkRequest("https://localhost:" + this.mockServer.httpsPort());
        HttpExecuteResponse response = client.prepareRequest(HttpExecuteRequest.builder().request((SdkHttpRequest)request).contentStreamProvider((ContentStreamProvider)request.contentStreamProvider().get()).build()).call();
        this.validateResponse(response, returnCode);
    }

    private void stubForMockRequest(int returnCode) {
        WireMock.stubFor((MappingBuilder)WireMock.any((UrlPattern)WireMock.urlPathEqualTo((String)"/")).willReturn(WireMock.aResponse().withStatus(returnCode).withHeader("Some-Header", new String[]{"With Value"}).withBody("hello")));
    }

    private void validateResponse(HttpExecuteResponse response, int returnCode) throws IOException {
        WireMock.verify((int)1, (RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlMatching((String)"/")).withHeader("Host", WireMock.containing((String)"localhost")).withHeader("User-Agent", WireMock.equalTo((String)"hello-world!")).withRequestBody((ContentPattern)WireMock.equalTo((String)"Body")));
        Assertions.assertThat((String)IoUtils.toUtf8String((InputStream)response.responseBody().orElse(null))).isEqualTo((Object)"hello");
        Assertions.assertThat((Optional)response.httpResponse().firstMatchingHeader("Some-Header")).contains((Object)"With Value");
        Assertions.assertThat((int)response.httpResponse().statusCode()).isEqualTo(returnCode);
        this.mockServer.resetMappings();
    }

    private SdkHttpFullRequest mockSdkRequest(String uriString) {
        URI uri = URI.create(uriString);
        return SdkHttpFullRequest.builder().uri(uri).method(SdkHttpMethod.POST).putHeader("Host", uri.getHost()).putHeader("User-Agent", "hello-world!").contentStreamProvider(() -> new ByteArrayInputStream("Body".getBytes(StandardCharsets.UTF_8))).build();
    }

    protected final SdkHttpClient createSdkHttpClient() {
        return this.createSdkHttpClient(new SdkHttpClientOptions());
    }

    protected abstract SdkHttpClient createSdkHttpClient(SdkHttpClientOptions var1);

    protected static final class SdkHttpClientOptions {
        protected SdkHttpClientOptions() {
        }
    }
}

