/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
@Immutable
class DefaultSdkHttpFullResponse
implements SdkHttpFullResponse {
    private final String statusText;
    private final int statusCode;
    private final Map<String, List<String>> headers;
    private final AbortableInputStream content;

    private DefaultSdkHttpFullResponse(Builder builder) {
        Validate.isTrue((builder.statusCode > 0 ? 1 : 0) != 0, (String)"Status code must be positive.", (Object[])new Object[0]);
        this.statusCode = builder.statusCode;
        this.statusText = builder.statusText;
        this.headers = CollectionUtils.deepUnmodifiableMap((Map)builder.headers, () -> new TreeMap(String.CASE_INSENSITIVE_ORDER));
        this.content = builder.content;
    }

    @Override
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    @Override
    public Optional<AbortableInputStream> content() {
        return Optional.ofNullable(this.content);
    }

    @Override
    public Optional<String> statusText() {
        return Optional.ofNullable(this.statusText);
    }

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    public SdkHttpFullResponse.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    implements SdkHttpFullResponse.Builder {
        private String statusText;
        private int statusCode;
        private AbortableInputStream content;
        private Map<String, List<String>> headers = new LinkedHashMap<String, List<String>>();

        Builder() {
        }

        private Builder(DefaultSdkHttpFullResponse defaultSdkHttpFullResponse) {
            this.statusText = defaultSdkHttpFullResponse.statusText;
            this.statusCode = defaultSdkHttpFullResponse.statusCode;
            this.content = defaultSdkHttpFullResponse.content;
            this.headers = CollectionUtils.deepCopyMap((Map)defaultSdkHttpFullResponse.headers);
        }

        @Override
        public String statusText() {
            return this.statusText;
        }

        @Override
        public Builder statusText(String statusText) {
            this.statusText = statusText;
            return this;
        }

        @Override
        public int statusCode() {
            return this.statusCode;
        }

        @Override
        public Builder statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public AbortableInputStream content() {
            return this.content;
        }

        @Override
        public Builder content(AbortableInputStream content) {
            this.content = content;
            return this;
        }

        @Override
        public Builder putHeader(String headerName, List<String> headerValues) {
            Validate.paramNotNull((Object)headerName, (String)"headerName");
            Validate.paramNotNull(headerValues, (String)"headerValues");
            this.headers.put(headerName, new ArrayList<String>(headerValues));
            return this;
        }

        @Override
        public Builder headers(Map<String, List<String>> headers) {
            Validate.paramNotNull(headers, (String)"headers");
            this.headers = CollectionUtils.deepCopyMap(headers);
            return this;
        }

        @Override
        public Builder removeHeader(String headerName) {
            this.headers.remove(headerName);
            return this;
        }

        @Override
        public Builder clearHeaders() {
            this.headers.clear();
            return this;
        }

        @Override
        public Map<String, List<String>> headers() {
            return CollectionUtils.deepUnmodifiableMap(this.headers);
        }

        public SdkHttpFullResponse build() {
            return new DefaultSdkHttpFullResponse(this);
        }
    }
}

