/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.honeycode.DefaultHoneycodeBaseClientBuilder;
import software.amazon.awssdk.services.honeycode.DefaultHoneycodeClient;
import software.amazon.awssdk.services.honeycode.HoneycodeClient;
import software.amazon.awssdk.services.honeycode.HoneycodeClientBuilder;
import software.amazon.awssdk.services.honeycode.HoneycodeServiceClientConfiguration;
import software.amazon.awssdk.services.honeycode.endpoints.HoneycodeEndpointProvider;

@SdkInternalApi
final class DefaultHoneycodeClientBuilder
extends DefaultHoneycodeBaseClientBuilder<HoneycodeClientBuilder, HoneycodeClient>
implements HoneycodeClientBuilder {
    DefaultHoneycodeClientBuilder() {
    }

    @Override
    public DefaultHoneycodeClientBuilder endpointProvider(HoneycodeEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final HoneycodeClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultHoneycodeClientBuilder.validateClientOptions(clientConfiguration);
        HoneycodeServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultHoneycodeClient client = new DefaultHoneycodeClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private HoneycodeServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return HoneycodeServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

