/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ImportDataCharacterEncoding {
    UTF_8("UTF-8"),

    US_ASCII("US-ASCII"),

    ISO_8859_1("ISO-8859-1"),

    UTF_16_BE("UTF-16BE"),

    UTF_16_LE("UTF-16LE"),

    UTF_16("UTF-16"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ImportDataCharacterEncoding> VALUE_MAP = EnumUtils.uniqueIndex(
            ImportDataCharacterEncoding.class, ImportDataCharacterEncoding::toString);

    private final String value;

    private ImportDataCharacterEncoding(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ImportDataCharacterEncoding corresponding to the value
     */
    public static ImportDataCharacterEncoding fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ImportDataCharacterEncoding}s
     */
    public static Set<ImportDataCharacterEncoding> knownValues() {
        Set<ImportDataCharacterEncoding> knownValues = EnumSet.allOf(ImportDataCharacterEncoding.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
