/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.honeycode.model.CreatedRowsMapCopier;
import software.amazon.awssdk.services.honeycode.model.FailedBatchItem;
import software.amazon.awssdk.services.honeycode.model.FailedBatchItemsCopier;
import software.amazon.awssdk.services.honeycode.model.HoneycodeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchCreateTableRowsResponse
extends HoneycodeResponse
implements ToCopyableBuilder<Builder, BatchCreateTableRowsResponse> {
    private static final SdkField<Long> WORKBOOK_CURSOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("workbookCursor").getter(BatchCreateTableRowsResponse.getter(BatchCreateTableRowsResponse::workbookCursor)).setter(BatchCreateTableRowsResponse.setter(Builder::workbookCursor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workbookCursor").build()}).build();
    private static final SdkField<Map<String, String>> CREATED_ROWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("createdRows").getter(BatchCreateTableRowsResponse.getter(BatchCreateTableRowsResponse::createdRows)).setter(BatchCreateTableRowsResponse.setter(Builder::createdRows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdRows").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<FailedBatchItem>> FAILED_BATCH_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failedBatchItems").getter(BatchCreateTableRowsResponse.getter(BatchCreateTableRowsResponse::failedBatchItems)).setter(BatchCreateTableRowsResponse.setter(Builder::failedBatchItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedBatchItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailedBatchItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKBOOK_CURSOR_FIELD, CREATED_ROWS_FIELD, FAILED_BATCH_ITEMS_FIELD));
    private final Long workbookCursor;
    private final Map<String, String> createdRows;
    private final List<FailedBatchItem> failedBatchItems;

    private BatchCreateTableRowsResponse(BuilderImpl builder) {
        super(builder);
        this.workbookCursor = builder.workbookCursor;
        this.createdRows = builder.createdRows;
        this.failedBatchItems = builder.failedBatchItems;
    }

    public final Long workbookCursor() {
        return this.workbookCursor;
    }

    public final boolean hasCreatedRows() {
        return this.createdRows != null && !(this.createdRows instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> createdRows() {
        return this.createdRows;
    }

    public final boolean hasFailedBatchItems() {
        return this.failedBatchItems != null && !(this.failedBatchItems instanceof SdkAutoConstructList);
    }

    public final List<FailedBatchItem> failedBatchItems() {
        return this.failedBatchItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workbookCursor());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCreatedRows() ? this.createdRows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedBatchItems() ? this.failedBatchItems() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateTableRowsResponse)) {
            return false;
        }
        BatchCreateTableRowsResponse other = (BatchCreateTableRowsResponse)((Object)obj);
        return Objects.equals(this.workbookCursor(), other.workbookCursor()) && this.hasCreatedRows() == other.hasCreatedRows() && Objects.equals(this.createdRows(), other.createdRows()) && this.hasFailedBatchItems() == other.hasFailedBatchItems() && Objects.equals(this.failedBatchItems(), other.failedBatchItems());
    }

    public final String toString() {
        return ToString.builder((String)"BatchCreateTableRowsResponse").add("WorkbookCursor", (Object)this.workbookCursor()).add("CreatedRows", this.hasCreatedRows() ? this.createdRows() : null).add("FailedBatchItems", this.hasFailedBatchItems() ? this.failedBatchItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workbookCursor": {
                return Optional.ofNullable(clazz.cast(this.workbookCursor()));
            }
            case "createdRows": {
                return Optional.ofNullable(clazz.cast(this.createdRows()));
            }
            case "failedBatchItems": {
                return Optional.ofNullable(clazz.cast(this.failedBatchItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateTableRowsResponse, T> g) {
        return obj -> g.apply((BatchCreateTableRowsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HoneycodeResponse.BuilderImpl
    implements Builder {
        private Long workbookCursor;
        private Map<String, String> createdRows = DefaultSdkAutoConstructMap.getInstance();
        private List<FailedBatchItem> failedBatchItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateTableRowsResponse model) {
            super(model);
            this.workbookCursor(model.workbookCursor);
            this.createdRows(model.createdRows);
            this.failedBatchItems(model.failedBatchItems);
        }

        public final Long getWorkbookCursor() {
            return this.workbookCursor;
        }

        @Override
        public final Builder workbookCursor(Long workbookCursor) {
            this.workbookCursor = workbookCursor;
            return this;
        }

        public final void setWorkbookCursor(Long workbookCursor) {
            this.workbookCursor = workbookCursor;
        }

        public final Map<String, String> getCreatedRows() {
            if (this.createdRows instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.createdRows;
        }

        @Override
        public final Builder createdRows(Map<String, String> createdRows) {
            this.createdRows = CreatedRowsMapCopier.copy(createdRows);
            return this;
        }

        public final void setCreatedRows(Map<String, String> createdRows) {
            this.createdRows = CreatedRowsMapCopier.copy(createdRows);
        }

        public final Collection<FailedBatchItem.Builder> getFailedBatchItems() {
            if (this.failedBatchItems instanceof SdkAutoConstructList) {
                return null;
            }
            return this.failedBatchItems != null ? (Collection)this.failedBatchItems.stream().map(FailedBatchItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failedBatchItems(Collection<FailedBatchItem> failedBatchItems) {
            this.failedBatchItems = FailedBatchItemsCopier.copy(failedBatchItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedBatchItems(FailedBatchItem ... failedBatchItems) {
            this.failedBatchItems(Arrays.asList(failedBatchItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedBatchItems(Consumer<FailedBatchItem.Builder> ... failedBatchItems) {
            this.failedBatchItems(Stream.of(failedBatchItems).map(c -> (FailedBatchItem)((FailedBatchItem.Builder)FailedBatchItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFailedBatchItems(Collection<FailedBatchItem.BuilderImpl> failedBatchItems) {
            this.failedBatchItems = FailedBatchItemsCopier.copyFromBuilder(failedBatchItems);
        }

        @Override
        public BatchCreateTableRowsResponse build() {
            return new BatchCreateTableRowsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends HoneycodeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchCreateTableRowsResponse> {
        public Builder workbookCursor(Long var1);

        public Builder createdRows(Map<String, String> var1);

        public Builder failedBatchItems(Collection<FailedBatchItem> var1);

        public Builder failedBatchItems(FailedBatchItem ... var1);

        public Builder failedBatchItems(Consumer<FailedBatchItem.Builder> ... var1);
    }
}

