/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.honeycode.model.CreateRowData;
import software.amazon.awssdk.services.honeycode.model.CreateRowDataListCopier;
import software.amazon.awssdk.services.honeycode.model.HoneycodeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchCreateTableRowsRequest
extends HoneycodeRequest
implements ToCopyableBuilder<Builder, BatchCreateTableRowsRequest> {
    private static final SdkField<String> WORKBOOK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workbookId").getter(BatchCreateTableRowsRequest.getter(BatchCreateTableRowsRequest::workbookId)).setter(BatchCreateTableRowsRequest.setter(Builder::workbookId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workbookId").build()}).build();
    private static final SdkField<String> TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tableId").getter(BatchCreateTableRowsRequest.getter(BatchCreateTableRowsRequest::tableId)).setter(BatchCreateTableRowsRequest.setter(Builder::tableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("tableId").build()}).build();
    private static final SdkField<List<CreateRowData>> ROWS_TO_CREATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rowsToCreate").getter(BatchCreateTableRowsRequest.getter(BatchCreateTableRowsRequest::rowsToCreate)).setter(BatchCreateTableRowsRequest.setter(Builder::rowsToCreate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rowsToCreate").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CreateRowData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(BatchCreateTableRowsRequest.getter(BatchCreateTableRowsRequest::clientRequestToken)).setter(BatchCreateTableRowsRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKBOOK_ID_FIELD, TABLE_ID_FIELD, ROWS_TO_CREATE_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private final String workbookId;
    private final String tableId;
    private final List<CreateRowData> rowsToCreate;
    private final String clientRequestToken;

    private BatchCreateTableRowsRequest(BuilderImpl builder) {
        super(builder);
        this.workbookId = builder.workbookId;
        this.tableId = builder.tableId;
        this.rowsToCreate = builder.rowsToCreate;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public final String workbookId() {
        return this.workbookId;
    }

    public final String tableId() {
        return this.tableId;
    }

    public final boolean hasRowsToCreate() {
        return this.rowsToCreate != null && !(this.rowsToCreate instanceof SdkAutoConstructList);
    }

    public final List<CreateRowData> rowsToCreate() {
        return this.rowsToCreate;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workbookId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRowsToCreate() ? this.rowsToCreate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateTableRowsRequest)) {
            return false;
        }
        BatchCreateTableRowsRequest other = (BatchCreateTableRowsRequest)((Object)obj);
        return Objects.equals(this.workbookId(), other.workbookId()) && Objects.equals(this.tableId(), other.tableId()) && this.hasRowsToCreate() == other.hasRowsToCreate() && Objects.equals(this.rowsToCreate(), other.rowsToCreate()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public final String toString() {
        return ToString.builder((String)"BatchCreateTableRowsRequest").add("WorkbookId", (Object)this.workbookId()).add("TableId", (Object)this.tableId()).add("RowsToCreate", this.hasRowsToCreate() ? this.rowsToCreate() : null).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workbookId": {
                return Optional.ofNullable(clazz.cast(this.workbookId()));
            }
            case "tableId": {
                return Optional.ofNullable(clazz.cast(this.tableId()));
            }
            case "rowsToCreate": {
                return Optional.ofNullable(clazz.cast(this.rowsToCreate()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateTableRowsRequest, T> g) {
        return obj -> g.apply((BatchCreateTableRowsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends HoneycodeRequest.BuilderImpl
    implements Builder {
        private String workbookId;
        private String tableId;
        private List<CreateRowData> rowsToCreate = DefaultSdkAutoConstructList.getInstance();
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateTableRowsRequest model) {
            super(model);
            this.workbookId(model.workbookId);
            this.tableId(model.tableId);
            this.rowsToCreate(model.rowsToCreate);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getWorkbookId() {
            return this.workbookId;
        }

        @Override
        public final Builder workbookId(String workbookId) {
            this.workbookId = workbookId;
            return this;
        }

        public final void setWorkbookId(String workbookId) {
            this.workbookId = workbookId;
        }

        public final String getTableId() {
            return this.tableId;
        }

        @Override
        public final Builder tableId(String tableId) {
            this.tableId = tableId;
            return this;
        }

        public final void setTableId(String tableId) {
            this.tableId = tableId;
        }

        public final Collection<CreateRowData.Builder> getRowsToCreate() {
            if (this.rowsToCreate instanceof SdkAutoConstructList) {
                return null;
            }
            return this.rowsToCreate != null ? (Collection)this.rowsToCreate.stream().map(CreateRowData::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rowsToCreate(Collection<CreateRowData> rowsToCreate) {
            this.rowsToCreate = CreateRowDataListCopier.copy(rowsToCreate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rowsToCreate(CreateRowData ... rowsToCreate) {
            this.rowsToCreate(Arrays.asList(rowsToCreate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rowsToCreate(Consumer<CreateRowData.Builder> ... rowsToCreate) {
            this.rowsToCreate(Stream.of(rowsToCreate).map(c -> (CreateRowData)((CreateRowData.Builder)CreateRowData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRowsToCreate(Collection<CreateRowData.BuilderImpl> rowsToCreate) {
            this.rowsToCreate = CreateRowDataListCopier.copyFromBuilder(rowsToCreate);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchCreateTableRowsRequest build() {
            return new BatchCreateTableRowsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends HoneycodeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchCreateTableRowsRequest> {
        public Builder workbookId(String var1);

        public Builder tableId(String var1);

        public Builder rowsToCreate(Collection<CreateRowData> var1);

        public Builder rowsToCreate(CreateRowData ... var1);

        public Builder rowsToCreate(Consumer<CreateRowData.Builder> ... var1);

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

