/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the result of a single upsert row request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpsertRowsResult implements SdkPojo, Serializable,
        ToCopyableBuilder<UpsertRowsResult.Builder, UpsertRowsResult> {
    private static final SdkField<List<String>> ROW_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("rowIds")
            .getter(getter(UpsertRowsResult::rowIds))
            .setter(setter(Builder::rowIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rowIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> UPSERT_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("upsertAction").getter(getter(UpsertRowsResult::upsertActionAsString))
            .setter(setter(Builder::upsertAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upsertAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROW_IDS_FIELD,
            UPSERT_ACTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> rowIds;

    private final String upsertAction;

    private UpsertRowsResult(BuilderImpl builder) {
        this.rowIds = builder.rowIds;
        this.upsertAction = builder.upsertAction;
    }

    /**
     * Returns true if the RowIds property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasRowIds() {
        return rowIds != null && !(rowIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of row ids that were changed as part of an upsert row operation. If the upsert resulted in an update,
     * this list could potentially contain multiple rows that matched the filter and hence got updated. If the upsert
     * resulted in an append, this list would only have the single row that was appended.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRowIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of row ids that were changed as part of an upsert row operation. If the upsert resulted in an
     *         update, this list could potentially contain multiple rows that matched the filter and hence got updated.
     *         If the upsert resulted in an append, this list would only have the single row that was appended.
     */
    public final List<String> rowIds() {
        return rowIds;
    }

    /**
     * <p>
     * The result of the upsert action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #upsertAction} will
     * return {@link UpsertAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #upsertActionAsString}.
     * </p>
     * 
     * @return The result of the upsert action.
     * @see UpsertAction
     */
    public final UpsertAction upsertAction() {
        return UpsertAction.fromValue(upsertAction);
    }

    /**
     * <p>
     * The result of the upsert action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #upsertAction} will
     * return {@link UpsertAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #upsertActionAsString}.
     * </p>
     * 
     * @return The result of the upsert action.
     * @see UpsertAction
     */
    public final String upsertActionAsString() {
        return upsertAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRowIds() ? rowIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(upsertActionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpsertRowsResult)) {
            return false;
        }
        UpsertRowsResult other = (UpsertRowsResult) obj;
        return hasRowIds() == other.hasRowIds() && Objects.equals(rowIds(), other.rowIds())
                && Objects.equals(upsertActionAsString(), other.upsertActionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpsertRowsResult").add("RowIds", hasRowIds() ? rowIds() : null)
                .add("UpsertAction", upsertActionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "rowIds":
            return Optional.ofNullable(clazz.cast(rowIds()));
        case "upsertAction":
            return Optional.ofNullable(clazz.cast(upsertActionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpsertRowsResult, T> g) {
        return obj -> g.apply((UpsertRowsResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpsertRowsResult> {
        /**
         * <p>
         * The list of row ids that were changed as part of an upsert row operation. If the upsert resulted in an
         * update, this list could potentially contain multiple rows that matched the filter and hence got updated. If
         * the upsert resulted in an append, this list would only have the single row that was appended.
         * </p>
         * 
         * @param rowIds
         *        The list of row ids that were changed as part of an upsert row operation. If the upsert resulted in an
         *        update, this list could potentially contain multiple rows that matched the filter and hence got
         *        updated. If the upsert resulted in an append, this list would only have the single row that was
         *        appended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowIds(Collection<String> rowIds);

        /**
         * <p>
         * The list of row ids that were changed as part of an upsert row operation. If the upsert resulted in an
         * update, this list could potentially contain multiple rows that matched the filter and hence got updated. If
         * the upsert resulted in an append, this list would only have the single row that was appended.
         * </p>
         * 
         * @param rowIds
         *        The list of row ids that were changed as part of an upsert row operation. If the upsert resulted in an
         *        update, this list could potentially contain multiple rows that matched the filter and hence got
         *        updated. If the upsert resulted in an append, this list would only have the single row that was
         *        appended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowIds(String... rowIds);

        /**
         * <p>
         * The result of the upsert action.
         * </p>
         * 
         * @param upsertAction
         *        The result of the upsert action.
         * @see UpsertAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpsertAction
         */
        Builder upsertAction(String upsertAction);

        /**
         * <p>
         * The result of the upsert action.
         * </p>
         * 
         * @param upsertAction
         *        The result of the upsert action.
         * @see UpsertAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpsertAction
         */
        Builder upsertAction(UpsertAction upsertAction);
    }

    static final class BuilderImpl implements Builder {
        private List<String> rowIds = DefaultSdkAutoConstructList.getInstance();

        private String upsertAction;

        private BuilderImpl() {
        }

        private BuilderImpl(UpsertRowsResult model) {
            rowIds(model.rowIds);
            upsertAction(model.upsertAction);
        }

        public final Collection<String> getRowIds() {
            if (rowIds instanceof SdkAutoConstructList) {
                return null;
            }
            return rowIds;
        }

        @Override
        public final Builder rowIds(Collection<String> rowIds) {
            this.rowIds = RowIdListCopier.copy(rowIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rowIds(String... rowIds) {
            rowIds(Arrays.asList(rowIds));
            return this;
        }

        public final void setRowIds(Collection<String> rowIds) {
            this.rowIds = RowIdListCopier.copy(rowIds);
        }

        public final String getUpsertAction() {
            return upsertAction;
        }

        @Override
        public final Builder upsertAction(String upsertAction) {
            this.upsertAction = upsertAction;
            return this;
        }

        @Override
        public final Builder upsertAction(UpsertAction upsertAction) {
            this.upsertAction(upsertAction == null ? null : upsertAction.toString());
            return this;
        }

        public final void setUpsertAction(String upsertAction) {
            this.upsertAction = upsertAction;
        }

        @Override
        public UpsertRowsResult build() {
            return new UpsertRowsResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
