/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Data needed to create a single row in a table as part of the BatchCreateTableRows request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRowData implements SdkPojo, Serializable, ToCopyableBuilder<UpdateRowData.Builder, UpdateRowData> {
    private static final SdkField<String> ROW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("rowId")
            .getter(getter(UpdateRowData::rowId)).setter(setter(Builder::rowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rowId").build()).build();

    private static final SdkField<Map<String, CellInput>> CELLS_TO_UPDATE_FIELD = SdkField
            .<Map<String, CellInput>> builder(MarshallingType.MAP)
            .memberName("cellsToUpdate")
            .getter(getter(UpdateRowData::cellsToUpdate))
            .setter(setter(Builder::cellsToUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cellsToUpdate").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<CellInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(CellInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROW_ID_FIELD,
            CELLS_TO_UPDATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String rowId;

    private final Map<String, CellInput> cellsToUpdate;

    private UpdateRowData(BuilderImpl builder) {
        this.rowId = builder.rowId;
        this.cellsToUpdate = builder.cellsToUpdate;
    }

    /**
     * <p>
     * The id of the row that needs to be updated.
     * </p>
     * 
     * @return The id of the row that needs to be updated.
     */
    public final String rowId() {
        return rowId;
    }

    /**
     * Returns true if the CellsToUpdate property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasCellsToUpdate() {
        return cellsToUpdate != null && !(cellsToUpdate instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map representing the cells to update in the given row. The key is the column id of the cell and the value is
     * the CellInput object that represents the data to set in that cell.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCellsToUpdate()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map representing the cells to update in the given row. The key is the column id of the cell and the
     *         value is the CellInput object that represents the data to set in that cell.
     */
    public final Map<String, CellInput> cellsToUpdate() {
        return cellsToUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rowId());
        hashCode = 31 * hashCode + Objects.hashCode(hasCellsToUpdate() ? cellsToUpdate() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRowData)) {
            return false;
        }
        UpdateRowData other = (UpdateRowData) obj;
        return Objects.equals(rowId(), other.rowId()) && hasCellsToUpdate() == other.hasCellsToUpdate()
                && Objects.equals(cellsToUpdate(), other.cellsToUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRowData").add("RowId", rowId())
                .add("CellsToUpdate", hasCellsToUpdate() ? cellsToUpdate() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "rowId":
            return Optional.ofNullable(clazz.cast(rowId()));
        case "cellsToUpdate":
            return Optional.ofNullable(clazz.cast(cellsToUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRowData, T> g) {
        return obj -> g.apply((UpdateRowData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateRowData> {
        /**
         * <p>
         * The id of the row that needs to be updated.
         * </p>
         * 
         * @param rowId
         *        The id of the row that needs to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowId(String rowId);

        /**
         * <p>
         * A map representing the cells to update in the given row. The key is the column id of the cell and the value
         * is the CellInput object that represents the data to set in that cell.
         * </p>
         * 
         * @param cellsToUpdate
         *        A map representing the cells to update in the given row. The key is the column id of the cell and the
         *        value is the CellInput object that represents the data to set in that cell.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cellsToUpdate(Map<String, CellInput> cellsToUpdate);
    }

    static final class BuilderImpl implements Builder {
        private String rowId;

        private Map<String, CellInput> cellsToUpdate = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRowData model) {
            rowId(model.rowId);
            cellsToUpdate(model.cellsToUpdate);
        }

        public final String getRowId() {
            return rowId;
        }

        @Override
        public final Builder rowId(String rowId) {
            this.rowId = rowId;
            return this;
        }

        public final void setRowId(String rowId) {
            this.rowId = rowId;
        }

        public final Map<String, CellInput.Builder> getCellsToUpdate() {
            if (cellsToUpdate instanceof SdkAutoConstructMap) {
                return null;
            }
            return cellsToUpdate != null ? CollectionUtils.mapValues(cellsToUpdate, CellInput::toBuilder) : null;
        }

        @Override
        public final Builder cellsToUpdate(Map<String, CellInput> cellsToUpdate) {
            this.cellsToUpdate = RowDataInputCopier.copy(cellsToUpdate);
            return this;
        }

        public final void setCellsToUpdate(Map<String, CellInput.BuilderImpl> cellsToUpdate) {
            this.cellsToUpdate = RowDataInputCopier.copyFromBuilder(cellsToUpdate);
        }

        @Override
        public UpdateRowData build() {
            return new UpdateRowData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
