/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTablesResponse extends HoneycodeResponse implements
        ToCopyableBuilder<ListTablesResponse.Builder, ListTablesResponse> {
    private static final SdkField<List<Table>> TABLES_FIELD = SdkField
            .<List<Table>> builder(MarshallingType.LIST)
            .memberName("tables")
            .getter(getter(ListTablesResponse::tables))
            .setter(setter(Builder::tables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tables").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Table> builder(MarshallingType.SDK_POJO)
                                            .constructor(Table::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTablesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Long> WORKBOOK_CURSOR_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("workbookCursor").getter(getter(ListTablesResponse::workbookCursor))
            .setter(setter(Builder::workbookCursor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workbookCursor").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLES_FIELD,
            NEXT_TOKEN_FIELD, WORKBOOK_CURSOR_FIELD));

    private final List<Table> tables;

    private final String nextToken;

    private final Long workbookCursor;

    private ListTablesResponse(BuilderImpl builder) {
        super(builder);
        this.tables = builder.tables;
        this.nextToken = builder.nextToken;
        this.workbookCursor = builder.workbookCursor;
    }

    /**
     * Returns true if the Tables property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTables() {
        return tables != null && !(tables instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of tables in the workbook.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTables()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of tables in the workbook.
     */
    public final List<Table> tables() {
        return tables;
    }

    /**
     * <p>
     * Provides the pagination token to load the next page if there are more results matching the request. If a
     * pagination token is not present in the response, it means that all data matching the request has been loaded.
     * </p>
     * 
     * @return Provides the pagination token to load the next page if there are more results matching the request. If a
     *         pagination token is not present in the response, it means that all data matching the request has been
     *         loaded.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Indicates the cursor of the workbook at which the data returned by this request is read. Workbook cursor keeps
     * increasing with every update and the increments are not sequential.
     * </p>
     * 
     * @return Indicates the cursor of the workbook at which the data returned by this request is read. Workbook cursor
     *         keeps increasing with every update and the increments are not sequential.
     */
    public final Long workbookCursor() {
        return workbookCursor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTables() ? tables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(workbookCursor());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTablesResponse)) {
            return false;
        }
        ListTablesResponse other = (ListTablesResponse) obj;
        return hasTables() == other.hasTables() && Objects.equals(tables(), other.tables())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(workbookCursor(), other.workbookCursor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTablesResponse").add("Tables", hasTables() ? tables() : null).add("NextToken", nextToken())
                .add("WorkbookCursor", workbookCursor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tables":
            return Optional.ofNullable(clazz.cast(tables()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "workbookCursor":
            return Optional.ofNullable(clazz.cast(workbookCursor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTablesResponse, T> g) {
        return obj -> g.apply((ListTablesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HoneycodeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTablesResponse> {
        /**
         * <p>
         * The list of tables in the workbook.
         * </p>
         * 
         * @param tables
         *        The list of tables in the workbook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tables(Collection<Table> tables);

        /**
         * <p>
         * The list of tables in the workbook.
         * </p>
         * 
         * @param tables
         *        The list of tables in the workbook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tables(Table... tables);

        /**
         * <p>
         * The list of tables in the workbook.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Table>
         * .Builder} avoiding the need to create one manually via {@link List<Table>
         * #builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Table>
         * .Builder#build()} is called immediately and its result is passed to {@link #tables(List
         * <Table>
         * )}.
         * 
         * @param tables
         *        a consumer that will call methods on {@link List<Table>
         *        .Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tables(List
         *      <Table>
         *      )
         */
        Builder tables(Consumer<Table.Builder>... tables);

        /**
         * <p>
         * Provides the pagination token to load the next page if there are more results matching the request. If a
         * pagination token is not present in the response, it means that all data matching the request has been loaded.
         * </p>
         * 
         * @param nextToken
         *        Provides the pagination token to load the next page if there are more results matching the request. If
         *        a pagination token is not present in the response, it means that all data matching the request has
         *        been loaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Indicates the cursor of the workbook at which the data returned by this request is read. Workbook cursor
         * keeps increasing with every update and the increments are not sequential.
         * </p>
         * 
         * @param workbookCursor
         *        Indicates the cursor of the workbook at which the data returned by this request is read. Workbook
         *        cursor keeps increasing with every update and the increments are not sequential.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workbookCursor(Long workbookCursor);
    }

    static final class BuilderImpl extends HoneycodeResponse.BuilderImpl implements Builder {
        private List<Table> tables = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Long workbookCursor;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTablesResponse model) {
            super(model);
            tables(model.tables);
            nextToken(model.nextToken);
            workbookCursor(model.workbookCursor);
        }

        public final Collection<Table.Builder> getTables() {
            if (tables instanceof SdkAutoConstructList) {
                return null;
            }
            return tables != null ? tables.stream().map(Table::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tables(Collection<Table> tables) {
            this.tables = TablesCopier.copy(tables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tables(Table... tables) {
            tables(Arrays.asList(tables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tables(Consumer<Table.Builder>... tables) {
            tables(Stream.of(tables).map(c -> Table.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTables(Collection<Table.BuilderImpl> tables) {
            this.tables = TablesCopier.copyFromBuilder(tables);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Long getWorkbookCursor() {
            return workbookCursor;
        }

        @Override
        public final Builder workbookCursor(Long workbookCursor) {
            this.workbookCursor = workbookCursor;
            return this;
        }

        public final void setWorkbookCursor(Long workbookCursor) {
            this.workbookCursor = workbookCursor;
        }

        @Override
        public ListTablesResponse build() {
            return new ListTablesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
