/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains the options relating to parsing delimited text as part of an import request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DelimitedTextImportOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<DelimitedTextImportOptions.Builder, DelimitedTextImportOptions> {
    private static final SdkField<String> DELIMITER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("delimiter").getter(getter(DelimitedTextImportOptions::delimiter)).setter(setter(Builder::delimiter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("delimiter").build()).build();

    private static final SdkField<Boolean> HAS_HEADER_ROW_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("hasHeaderRow").getter(getter(DelimitedTextImportOptions::hasHeaderRow))
            .setter(setter(Builder::hasHeaderRow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hasHeaderRow").build()).build();

    private static final SdkField<Boolean> IGNORE_EMPTY_ROWS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ignoreEmptyRows").getter(getter(DelimitedTextImportOptions::ignoreEmptyRows))
            .setter(setter(Builder::ignoreEmptyRows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ignoreEmptyRows").build()).build();

    private static final SdkField<String> DATA_CHARACTER_ENCODING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataCharacterEncoding").getter(getter(DelimitedTextImportOptions::dataCharacterEncodingAsString))
            .setter(setter(Builder::dataCharacterEncoding))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataCharacterEncoding").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIMITER_FIELD,
            HAS_HEADER_ROW_FIELD, IGNORE_EMPTY_ROWS_FIELD, DATA_CHARACTER_ENCODING_FIELD));

    private static final long serialVersionUID = 1L;

    private final String delimiter;

    private final Boolean hasHeaderRow;

    private final Boolean ignoreEmptyRows;

    private final String dataCharacterEncoding;

    private DelimitedTextImportOptions(BuilderImpl builder) {
        this.delimiter = builder.delimiter;
        this.hasHeaderRow = builder.hasHeaderRow;
        this.ignoreEmptyRows = builder.ignoreEmptyRows;
        this.dataCharacterEncoding = builder.dataCharacterEncoding;
    }

    /**
     * <p>
     * The delimiter to use for separating columns in a single row of the input.
     * </p>
     * 
     * @return The delimiter to use for separating columns in a single row of the input.
     */
    public final String delimiter() {
        return delimiter;
    }

    /**
     * <p>
     * Indicates whether the input file has a header row at the top containing the column names.
     * </p>
     * 
     * @return Indicates whether the input file has a header row at the top containing the column names.
     */
    public final Boolean hasHeaderRow() {
        return hasHeaderRow;
    }

    /**
     * <p>
     * A parameter to indicate whether empty rows should be ignored or be included in the import.
     * </p>
     * 
     * @return A parameter to indicate whether empty rows should be ignored or be included in the import.
     */
    public final Boolean ignoreEmptyRows() {
        return ignoreEmptyRows;
    }

    /**
     * <p>
     * The encoding of the data in the input file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataCharacterEncoding} will return {@link ImportDataCharacterEncoding#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #dataCharacterEncodingAsString}.
     * </p>
     * 
     * @return The encoding of the data in the input file.
     * @see ImportDataCharacterEncoding
     */
    public final ImportDataCharacterEncoding dataCharacterEncoding() {
        return ImportDataCharacterEncoding.fromValue(dataCharacterEncoding);
    }

    /**
     * <p>
     * The encoding of the data in the input file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataCharacterEncoding} will return {@link ImportDataCharacterEncoding#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #dataCharacterEncodingAsString}.
     * </p>
     * 
     * @return The encoding of the data in the input file.
     * @see ImportDataCharacterEncoding
     */
    public final String dataCharacterEncodingAsString() {
        return dataCharacterEncoding;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(delimiter());
        hashCode = 31 * hashCode + Objects.hashCode(hasHeaderRow());
        hashCode = 31 * hashCode + Objects.hashCode(ignoreEmptyRows());
        hashCode = 31 * hashCode + Objects.hashCode(dataCharacterEncodingAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DelimitedTextImportOptions)) {
            return false;
        }
        DelimitedTextImportOptions other = (DelimitedTextImportOptions) obj;
        return Objects.equals(delimiter(), other.delimiter()) && Objects.equals(hasHeaderRow(), other.hasHeaderRow())
                && Objects.equals(ignoreEmptyRows(), other.ignoreEmptyRows())
                && Objects.equals(dataCharacterEncodingAsString(), other.dataCharacterEncodingAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DelimitedTextImportOptions").add("Delimiter", delimiter()).add("HasHeaderRow", hasHeaderRow())
                .add("IgnoreEmptyRows", ignoreEmptyRows()).add("DataCharacterEncoding", dataCharacterEncodingAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "delimiter":
            return Optional.ofNullable(clazz.cast(delimiter()));
        case "hasHeaderRow":
            return Optional.ofNullable(clazz.cast(hasHeaderRow()));
        case "ignoreEmptyRows":
            return Optional.ofNullable(clazz.cast(ignoreEmptyRows()));
        case "dataCharacterEncoding":
            return Optional.ofNullable(clazz.cast(dataCharacterEncodingAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DelimitedTextImportOptions, T> g) {
        return obj -> g.apply((DelimitedTextImportOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DelimitedTextImportOptions> {
        /**
         * <p>
         * The delimiter to use for separating columns in a single row of the input.
         * </p>
         * 
         * @param delimiter
         *        The delimiter to use for separating columns in a single row of the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delimiter(String delimiter);

        /**
         * <p>
         * Indicates whether the input file has a header row at the top containing the column names.
         * </p>
         * 
         * @param hasHeaderRow
         *        Indicates whether the input file has a header row at the top containing the column names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasHeaderRow(Boolean hasHeaderRow);

        /**
         * <p>
         * A parameter to indicate whether empty rows should be ignored or be included in the import.
         * </p>
         * 
         * @param ignoreEmptyRows
         *        A parameter to indicate whether empty rows should be ignored or be included in the import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ignoreEmptyRows(Boolean ignoreEmptyRows);

        /**
         * <p>
         * The encoding of the data in the input file.
         * </p>
         * 
         * @param dataCharacterEncoding
         *        The encoding of the data in the input file.
         * @see ImportDataCharacterEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportDataCharacterEncoding
         */
        Builder dataCharacterEncoding(String dataCharacterEncoding);

        /**
         * <p>
         * The encoding of the data in the input file.
         * </p>
         * 
         * @param dataCharacterEncoding
         *        The encoding of the data in the input file.
         * @see ImportDataCharacterEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportDataCharacterEncoding
         */
        Builder dataCharacterEncoding(ImportDataCharacterEncoding dataCharacterEncoding);
    }

    static final class BuilderImpl implements Builder {
        private String delimiter;

        private Boolean hasHeaderRow;

        private Boolean ignoreEmptyRows;

        private String dataCharacterEncoding;

        private BuilderImpl() {
        }

        private BuilderImpl(DelimitedTextImportOptions model) {
            delimiter(model.delimiter);
            hasHeaderRow(model.hasHeaderRow);
            ignoreEmptyRows(model.ignoreEmptyRows);
            dataCharacterEncoding(model.dataCharacterEncoding);
        }

        public final String getDelimiter() {
            return delimiter;
        }

        @Override
        public final Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public final void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        public final Boolean getHasHeaderRow() {
            return hasHeaderRow;
        }

        @Override
        public final Builder hasHeaderRow(Boolean hasHeaderRow) {
            this.hasHeaderRow = hasHeaderRow;
            return this;
        }

        public final void setHasHeaderRow(Boolean hasHeaderRow) {
            this.hasHeaderRow = hasHeaderRow;
        }

        public final Boolean getIgnoreEmptyRows() {
            return ignoreEmptyRows;
        }

        @Override
        public final Builder ignoreEmptyRows(Boolean ignoreEmptyRows) {
            this.ignoreEmptyRows = ignoreEmptyRows;
            return this;
        }

        public final void setIgnoreEmptyRows(Boolean ignoreEmptyRows) {
            this.ignoreEmptyRows = ignoreEmptyRows;
        }

        public final String getDataCharacterEncoding() {
            return dataCharacterEncoding;
        }

        @Override
        public final Builder dataCharacterEncoding(String dataCharacterEncoding) {
            this.dataCharacterEncoding = dataCharacterEncoding;
            return this;
        }

        @Override
        public final Builder dataCharacterEncoding(ImportDataCharacterEncoding dataCharacterEncoding) {
            this.dataCharacterEncoding(dataCharacterEncoding == null ? null : dataCharacterEncoding.toString());
            return this;
        }

        public final void setDataCharacterEncoding(String dataCharacterEncoding) {
            this.dataCharacterEncoding = dataCharacterEncoding;
        }

        @Override
        public DelimitedTextImportOptions build() {
            return new DelimitedTextImportOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
