/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EventTypeActionability {
    ACTION_REQUIRED("ACTION_REQUIRED"),
    ACTION_MAY_BE_REQUIRED("ACTION_MAY_BE_REQUIRED"),
    INFORMATIONAL("INFORMATIONAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EventTypeActionability> VALUE_MAP;
    private final String value;

    private EventTypeActionability(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventTypeActionability fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventTypeActionability> knownValues() {
        EnumSet<EventTypeActionability> knownValues = EnumSet.allOf(EventTypeActionability.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EventTypeActionability.class, EventTypeActionability::toString);
    }
}

