/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EventActionability {
    ACTION_REQUIRED("ACTION_REQUIRED"),
    ACTION_MAY_BE_REQUIRED("ACTION_MAY_BE_REQUIRED"),
    INFORMATIONAL("INFORMATIONAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EventActionability> VALUE_MAP;
    private final String value;

    private EventActionability(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventActionability fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventActionability> knownValues() {
        EnumSet<EventActionability> knownValues = EnumSet.allOf(EventActionability.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EventActionability.class, EventActionability::toString);
    }
}

