/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.globalaccelerator.GlobalAcceleratorAsyncClient;
import software.amazon.awssdk.services.globalaccelerator.internal.UserAgentUtils;
import software.amazon.awssdk.services.globalaccelerator.model.Attachment;
import software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountAttachmentsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountAttachmentsResponse;

public class ListCrossAccountAttachmentsPublisher
implements SdkPublisher<ListCrossAccountAttachmentsResponse> {
    private final GlobalAcceleratorAsyncClient client;
    private final ListCrossAccountAttachmentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCrossAccountAttachmentsPublisher(GlobalAcceleratorAsyncClient client, ListCrossAccountAttachmentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCrossAccountAttachmentsPublisher(GlobalAcceleratorAsyncClient client, ListCrossAccountAttachmentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCrossAccountAttachmentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCrossAccountAttachmentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Attachment> crossAccountAttachments() {
        Function<ListCrossAccountAttachmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.crossAccountAttachments() != null) {
                return response.crossAccountAttachments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCrossAccountAttachmentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCrossAccountAttachmentsResponseFetcher
    implements AsyncPageFetcher<ListCrossAccountAttachmentsResponse> {
        private ListCrossAccountAttachmentsResponseFetcher() {
        }

        public boolean hasNextPage(ListCrossAccountAttachmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCrossAccountAttachmentsResponse> nextPage(ListCrossAccountAttachmentsResponse previousPage) {
            if (previousPage == null) {
                return ListCrossAccountAttachmentsPublisher.this.client.listCrossAccountAttachments(ListCrossAccountAttachmentsPublisher.this.firstRequest);
            }
            return ListCrossAccountAttachmentsPublisher.this.client.listCrossAccountAttachments((ListCrossAccountAttachmentsRequest)((Object)ListCrossAccountAttachmentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

