/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.globalaccelerator.GlobalAcceleratorAsyncClient;
import software.amazon.awssdk.services.globalaccelerator.internal.UserAgentUtils;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.PortMapping;

public class ListCustomRoutingPortMappingsPublisher
implements SdkPublisher<ListCustomRoutingPortMappingsResponse> {
    private final GlobalAcceleratorAsyncClient client;
    private final ListCustomRoutingPortMappingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCustomRoutingPortMappingsPublisher(GlobalAcceleratorAsyncClient client, ListCustomRoutingPortMappingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCustomRoutingPortMappingsPublisher(GlobalAcceleratorAsyncClient client, ListCustomRoutingPortMappingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCustomRoutingPortMappingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCustomRoutingPortMappingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PortMapping> portMappings() {
        Function<ListCustomRoutingPortMappingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.portMappings() != null) {
                return response.portMappings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCustomRoutingPortMappingsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCustomRoutingPortMappingsResponseFetcher
    implements AsyncPageFetcher<ListCustomRoutingPortMappingsResponse> {
        private ListCustomRoutingPortMappingsResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomRoutingPortMappingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCustomRoutingPortMappingsResponse> nextPage(ListCustomRoutingPortMappingsResponse previousPage) {
            if (previousPage == null) {
                return ListCustomRoutingPortMappingsPublisher.this.client.listCustomRoutingPortMappings(ListCustomRoutingPortMappingsPublisher.this.firstRequest);
            }
            return ListCustomRoutingPortMappingsPublisher.this.client.listCustomRoutingPortMappings((ListCustomRoutingPortMappingsRequest)((Object)ListCustomRoutingPortMappingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

