/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.globalaccelerator.model.GlobalAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.PortMapping;
import software.amazon.awssdk.services.globalaccelerator.model.PortMappingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCustomRoutingPortMappingsResponse
extends GlobalAcceleratorResponse
implements ToCopyableBuilder<Builder, ListCustomRoutingPortMappingsResponse> {
    private static final SdkField<List<PortMapping>> PORT_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PortMappings").getter(ListCustomRoutingPortMappingsResponse.getter(ListCustomRoutingPortMappingsResponse::portMappings)).setter(ListCustomRoutingPortMappingsResponse.setter(Builder::portMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PortMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCustomRoutingPortMappingsResponse.getter(ListCustomRoutingPortMappingsResponse::nextToken)).setter(ListCustomRoutingPortMappingsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORT_MAPPINGS_FIELD, NEXT_TOKEN_FIELD));
    private final List<PortMapping> portMappings;
    private final String nextToken;

    private ListCustomRoutingPortMappingsResponse(BuilderImpl builder) {
        super(builder);
        this.portMappings = builder.portMappings;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPortMappings() {
        return this.portMappings != null && !(this.portMappings instanceof SdkAutoConstructList);
    }

    public final List<PortMapping> portMappings() {
        return this.portMappings;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPortMappings() ? this.portMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomRoutingPortMappingsResponse)) {
            return false;
        }
        ListCustomRoutingPortMappingsResponse other = (ListCustomRoutingPortMappingsResponse)((Object)obj);
        return this.hasPortMappings() == other.hasPortMappings() && Objects.equals(this.portMappings(), other.portMappings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCustomRoutingPortMappingsResponse").add("PortMappings", this.hasPortMappings() ? this.portMappings() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PortMappings": {
                return Optional.ofNullable(clazz.cast(this.portMappings()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCustomRoutingPortMappingsResponse, T> g) {
        return obj -> g.apply((ListCustomRoutingPortMappingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlobalAcceleratorResponse.BuilderImpl
    implements Builder {
        private List<PortMapping> portMappings = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomRoutingPortMappingsResponse model) {
            super(model);
            this.portMappings(model.portMappings);
            this.nextToken(model.nextToken);
        }

        public final Collection<PortMapping.Builder> getPortMappings() {
            if (this.portMappings instanceof SdkAutoConstructList) {
                return null;
            }
            return this.portMappings != null ? (Collection)this.portMappings.stream().map(PortMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder portMappings(Collection<PortMapping> portMappings) {
            this.portMappings = PortMappingsCopier.copy(portMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portMappings(PortMapping ... portMappings) {
            this.portMappings(Arrays.asList(portMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portMappings(Consumer<PortMapping.Builder> ... portMappings) {
            this.portMappings(Stream.of(portMappings).map(c -> (PortMapping)((PortMapping.Builder)PortMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPortMappings(Collection<PortMapping.BuilderImpl> portMappings) {
            this.portMappings = PortMappingsCopier.copyFromBuilder(portMappings);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListCustomRoutingPortMappingsResponse build() {
            return new ListCustomRoutingPortMappingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlobalAcceleratorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCustomRoutingPortMappingsResponse> {
        public Builder portMappings(Collection<PortMapping> var1);

        public Builder portMappings(PortMapping ... var1);

        public Builder portMappings(Consumer<PortMapping.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

