/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingAccelerator;
import software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingAcceleratorsCopier;
import software.amazon.awssdk.services.globalaccelerator.model.GlobalAcceleratorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCustomRoutingAcceleratorsResponse
extends GlobalAcceleratorResponse
implements ToCopyableBuilder<Builder, ListCustomRoutingAcceleratorsResponse> {
    private static final SdkField<List<CustomRoutingAccelerator>> ACCELERATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Accelerators").getter(ListCustomRoutingAcceleratorsResponse.getter(ListCustomRoutingAcceleratorsResponse::accelerators)).setter(ListCustomRoutingAcceleratorsResponse.setter(Builder::accelerators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accelerators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomRoutingAccelerator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCustomRoutingAcceleratorsResponse.getter(ListCustomRoutingAcceleratorsResponse::nextToken)).setter(ListCustomRoutingAcceleratorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATORS_FIELD, NEXT_TOKEN_FIELD));
    private final List<CustomRoutingAccelerator> accelerators;
    private final String nextToken;

    private ListCustomRoutingAcceleratorsResponse(BuilderImpl builder) {
        super(builder);
        this.accelerators = builder.accelerators;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAccelerators() {
        return this.accelerators != null && !(this.accelerators instanceof SdkAutoConstructList);
    }

    public final List<CustomRoutingAccelerator> accelerators() {
        return this.accelerators;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccelerators() ? this.accelerators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomRoutingAcceleratorsResponse)) {
            return false;
        }
        ListCustomRoutingAcceleratorsResponse other = (ListCustomRoutingAcceleratorsResponse)((Object)obj);
        return this.hasAccelerators() == other.hasAccelerators() && Objects.equals(this.accelerators(), other.accelerators()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCustomRoutingAcceleratorsResponse").add("Accelerators", this.hasAccelerators() ? this.accelerators() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Accelerators": {
                return Optional.ofNullable(clazz.cast(this.accelerators()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCustomRoutingAcceleratorsResponse, T> g) {
        return obj -> g.apply((ListCustomRoutingAcceleratorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlobalAcceleratorResponse.BuilderImpl
    implements Builder {
        private List<CustomRoutingAccelerator> accelerators = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomRoutingAcceleratorsResponse model) {
            super(model);
            this.accelerators(model.accelerators);
            this.nextToken(model.nextToken);
        }

        public final Collection<CustomRoutingAccelerator.Builder> getAccelerators() {
            if (this.accelerators instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accelerators != null ? (Collection)this.accelerators.stream().map(CustomRoutingAccelerator::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accelerators(Collection<CustomRoutingAccelerator> accelerators) {
            this.accelerators = CustomRoutingAcceleratorsCopier.copy(accelerators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accelerators(CustomRoutingAccelerator ... accelerators) {
            this.accelerators(Arrays.asList(accelerators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accelerators(Consumer<CustomRoutingAccelerator.Builder> ... accelerators) {
            this.accelerators(Stream.of(accelerators).map(c -> (CustomRoutingAccelerator)((CustomRoutingAccelerator.Builder)CustomRoutingAccelerator.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAccelerators(Collection<CustomRoutingAccelerator.BuilderImpl> accelerators) {
            this.accelerators = CustomRoutingAcceleratorsCopier.copyFromBuilder(accelerators);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListCustomRoutingAcceleratorsResponse build() {
            return new ListCustomRoutingAcceleratorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlobalAcceleratorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCustomRoutingAcceleratorsResponse> {
        public Builder accelerators(Collection<CustomRoutingAccelerator> var1);

        public Builder accelerators(CustomRoutingAccelerator ... var1);

        public Builder accelerators(Consumer<CustomRoutingAccelerator.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

