/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingEndpointDescription;
import software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingEndpointDescriptionsCopier;
import software.amazon.awssdk.services.globalaccelerator.model.GlobalAcceleratorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddCustomRoutingEndpointsResponse
extends GlobalAcceleratorResponse
implements ToCopyableBuilder<Builder, AddCustomRoutingEndpointsResponse> {
    private static final SdkField<List<CustomRoutingEndpointDescription>> ENDPOINT_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EndpointDescriptions").getter(AddCustomRoutingEndpointsResponse.getter(AddCustomRoutingEndpointsResponse::endpointDescriptions)).setter(AddCustomRoutingEndpointsResponse.setter(Builder::endpointDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomRoutingEndpointDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ENDPOINT_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointGroupArn").getter(AddCustomRoutingEndpointsResponse.getter(AddCustomRoutingEndpointsResponse::endpointGroupArn)).setter(AddCustomRoutingEndpointsResponse.setter(Builder::endpointGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointGroupArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_DESCRIPTIONS_FIELD, ENDPOINT_GROUP_ARN_FIELD));
    private final List<CustomRoutingEndpointDescription> endpointDescriptions;
    private final String endpointGroupArn;

    private AddCustomRoutingEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.endpointDescriptions = builder.endpointDescriptions;
        this.endpointGroupArn = builder.endpointGroupArn;
    }

    public final boolean hasEndpointDescriptions() {
        return this.endpointDescriptions != null && !(this.endpointDescriptions instanceof SdkAutoConstructList);
    }

    public final List<CustomRoutingEndpointDescription> endpointDescriptions() {
        return this.endpointDescriptions;
    }

    public final String endpointGroupArn() {
        return this.endpointGroupArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpointDescriptions() ? this.endpointDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointGroupArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddCustomRoutingEndpointsResponse)) {
            return false;
        }
        AddCustomRoutingEndpointsResponse other = (AddCustomRoutingEndpointsResponse)((Object)obj);
        return this.hasEndpointDescriptions() == other.hasEndpointDescriptions() && Objects.equals(this.endpointDescriptions(), other.endpointDescriptions()) && Objects.equals(this.endpointGroupArn(), other.endpointGroupArn());
    }

    public final String toString() {
        return ToString.builder((String)"AddCustomRoutingEndpointsResponse").add("EndpointDescriptions", this.hasEndpointDescriptions() ? this.endpointDescriptions() : null).add("EndpointGroupArn", (Object)this.endpointGroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointDescriptions": {
                return Optional.ofNullable(clazz.cast(this.endpointDescriptions()));
            }
            case "EndpointGroupArn": {
                return Optional.ofNullable(clazz.cast(this.endpointGroupArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddCustomRoutingEndpointsResponse, T> g) {
        return obj -> g.apply((AddCustomRoutingEndpointsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlobalAcceleratorResponse.BuilderImpl
    implements Builder {
        private List<CustomRoutingEndpointDescription> endpointDescriptions = DefaultSdkAutoConstructList.getInstance();
        private String endpointGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AddCustomRoutingEndpointsResponse model) {
            super(model);
            this.endpointDescriptions(model.endpointDescriptions);
            this.endpointGroupArn(model.endpointGroupArn);
        }

        public final Collection<CustomRoutingEndpointDescription.Builder> getEndpointDescriptions() {
            if (this.endpointDescriptions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.endpointDescriptions != null ? (Collection)this.endpointDescriptions.stream().map(CustomRoutingEndpointDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder endpointDescriptions(Collection<CustomRoutingEndpointDescription> endpointDescriptions) {
            this.endpointDescriptions = CustomRoutingEndpointDescriptionsCopier.copy(endpointDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointDescriptions(CustomRoutingEndpointDescription ... endpointDescriptions) {
            this.endpointDescriptions(Arrays.asList(endpointDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointDescriptions(Consumer<CustomRoutingEndpointDescription.Builder> ... endpointDescriptions) {
            this.endpointDescriptions(Stream.of(endpointDescriptions).map(c -> (CustomRoutingEndpointDescription)((CustomRoutingEndpointDescription.Builder)CustomRoutingEndpointDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEndpointDescriptions(Collection<CustomRoutingEndpointDescription.BuilderImpl> endpointDescriptions) {
            this.endpointDescriptions = CustomRoutingEndpointDescriptionsCopier.copyFromBuilder(endpointDescriptions);
        }

        public final String getEndpointGroupArn() {
            return this.endpointGroupArn;
        }

        @Override
        public final Builder endpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
            return this;
        }

        public final void setEndpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
        }

        @Override
        public AddCustomRoutingEndpointsResponse build() {
            return new AddCustomRoutingEndpointsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlobalAcceleratorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddCustomRoutingEndpointsResponse> {
        public Builder endpointDescriptions(Collection<CustomRoutingEndpointDescription> var1);

        public Builder endpointDescriptions(CustomRoutingEndpointDescription ... var1);

        public Builder endpointDescriptions(Consumer<CustomRoutingEndpointDescription.Builder> ... var1);

        public Builder endpointGroupArn(String var1);
    }
}

