/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAcceleratorRequest extends GlobalAcceleratorRequest implements
        ToCopyableBuilder<CreateAcceleratorRequest.Builder, CreateAcceleratorRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateAcceleratorRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpAddressType").getter(getter(CreateAcceleratorRequest::ipAddressTypeAsString))
            .setter(setter(Builder::ipAddressType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressType").build()).build();

    private static final SdkField<List<String>> IP_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("IpAddresses")
            .getter(getter(CreateAcceleratorRequest::ipAddresses))
            .setter(setter(Builder::ipAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(CreateAcceleratorRequest::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IdempotencyToken")
            .getter(getter(CreateAcceleratorRequest::idempotencyToken))
            .setter(setter(Builder::idempotencyToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateAcceleratorRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            IP_ADDRESS_TYPE_FIELD, IP_ADDRESSES_FIELD, ENABLED_FIELD, IDEMPOTENCY_TOKEN_FIELD, TAGS_FIELD));

    private final String name;

    private final String ipAddressType;

    private final List<String> ipAddresses;

    private final Boolean enabled;

    private final String idempotencyToken;

    private final List<Tag> tags;

    private CreateAcceleratorRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.ipAddressType = builder.ipAddressType;
        this.ipAddresses = builder.ipAddresses;
        this.enabled = builder.enabled;
        this.idempotencyToken = builder.idempotencyToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of an accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric
     * characters or hyphens (-), and must not begin or end with a hyphen.
     * </p>
     * 
     * @return The name of an accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric
     *         characters or hyphens (-), and must not begin or end with a hyphen.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The value for the address type must be IPv4.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The value for the address type must be IPv4.
     * @see IpAddressType
     */
    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(ipAddressType);
    }

    /**
     * <p>
     * The value for the address type must be IPv4.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The value for the address type must be IPv4.
     * @see IpAddressType
     */
    public final String ipAddressTypeAsString() {
        return ipAddressType;
    }

    /**
     * Returns true if the IpAddresses property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasIpAddresses() {
        return ipAddresses != null && !(ipAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optionally, if you've added your own IP address pool to Global Accelerator (BYOIP), you can choose IP addresses
     * from your own pool to use for the accelerator's static IP addresses when you create an accelerator. You can
     * specify one or two addresses, separated by a space. Do not include the /32 suffix.
     * </p>
     * <p>
     * Only one IP address from each of your IP address ranges can be used for each accelerator. If you specify only one
     * IP address from your IP address range, Global Accelerator assigns a second static IP address for the accelerator
     * from the AWS IP address pool.
     * </p>
     * <p>
     * Note that you can't update IP addresses for an existing accelerator. To change them, you must create a new
     * accelerator with the new addresses.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own IP Addresses
     * (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIpAddresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Optionally, if you've added your own IP address pool to Global Accelerator (BYOIP), you can choose IP
     *         addresses from your own pool to use for the accelerator's static IP addresses when you create an
     *         accelerator. You can specify one or two addresses, separated by a space. Do not include the /32
     *         suffix.</p>
     *         <p>
     *         Only one IP address from each of your IP address ranges can be used for each accelerator. If you specify
     *         only one IP address from your IP address range, Global Accelerator assigns a second static IP address for
     *         the accelerator from the AWS IP address pool.
     *         </p>
     *         <p>
     *         Note that you can't update IP addresses for an existing accelerator. To change them, you must create a
     *         new accelerator with the new addresses.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own IP
     *         Addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.
     */
    public final List<String> ipAddresses() {
        return ipAddresses;
    }

    /**
     * <p>
     * Indicates whether an accelerator is enabled. The value is true or false. The default value is true.
     * </p>
     * <p>
     * If the value is set to true, an accelerator cannot be deleted. If set to false, the accelerator can be deleted.
     * </p>
     * 
     * @return Indicates whether an accelerator is enabled. The value is true or false. The default value is true. </p>
     *         <p>
     *         If the value is set to true, an accelerator cannot be deleted. If set to false, the accelerator can be
     *         deleted.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of an
     * accelerator.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of
     *         an accelerator.
     */
    public final String idempotencyToken() {
        return idempotencyToken;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Create tags for an accelerator.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in AWS
     * Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Create tags for an accelerator.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html"
     *         >Tagging in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpAddresses() ? ipAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(idempotencyToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAcceleratorRequest)) {
            return false;
        }
        CreateAcceleratorRequest other = (CreateAcceleratorRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(ipAddressTypeAsString(), other.ipAddressTypeAsString())
                && hasIpAddresses() == other.hasIpAddresses() && Objects.equals(ipAddresses(), other.ipAddresses())
                && Objects.equals(enabled(), other.enabled()) && Objects.equals(idempotencyToken(), other.idempotencyToken())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAcceleratorRequest").add("Name", name()).add("IpAddressType", ipAddressTypeAsString())
                .add("IpAddresses", hasIpAddresses() ? ipAddresses() : null).add("Enabled", enabled())
                .add("IdempotencyToken", idempotencyToken()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "IpAddressType":
            return Optional.ofNullable(clazz.cast(ipAddressTypeAsString()));
        case "IpAddresses":
            return Optional.ofNullable(clazz.cast(ipAddresses()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "IdempotencyToken":
            return Optional.ofNullable(clazz.cast(idempotencyToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAcceleratorRequest, T> g) {
        return obj -> g.apply((CreateAcceleratorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlobalAcceleratorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAcceleratorRequest> {
        /**
         * <p>
         * The name of an accelerator. The name can have a maximum of 32 characters, must contain only alphanumeric
         * characters or hyphens (-), and must not begin or end with a hyphen.
         * </p>
         * 
         * @param name
         *        The name of an accelerator. The name can have a maximum of 32 characters, must contain only
         *        alphanumeric characters or hyphens (-), and must not begin or end with a hyphen.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The value for the address type must be IPv4.
         * </p>
         * 
         * @param ipAddressType
         *        The value for the address type must be IPv4.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(String ipAddressType);

        /**
         * <p>
         * The value for the address type must be IPv4.
         * </p>
         * 
         * @param ipAddressType
         *        The value for the address type must be IPv4.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(IpAddressType ipAddressType);

        /**
         * <p>
         * Optionally, if you've added your own IP address pool to Global Accelerator (BYOIP), you can choose IP
         * addresses from your own pool to use for the accelerator's static IP addresses when you create an accelerator.
         * You can specify one or two addresses, separated by a space. Do not include the /32 suffix.
         * </p>
         * <p>
         * Only one IP address from each of your IP address ranges can be used for each accelerator. If you specify only
         * one IP address from your IP address range, Global Accelerator assigns a second static IP address for the
         * accelerator from the AWS IP address pool.
         * </p>
         * <p>
         * Note that you can't update IP addresses for an existing accelerator. To change them, you must create a new
         * accelerator with the new addresses.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own IP Addresses
         * (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.
         * </p>
         * 
         * @param ipAddresses
         *        Optionally, if you've added your own IP address pool to Global Accelerator (BYOIP), you can choose IP
         *        addresses from your own pool to use for the accelerator's static IP addresses when you create an
         *        accelerator. You can specify one or two addresses, separated by a space. Do not include the /32
         *        suffix.</p>
         *        <p>
         *        Only one IP address from each of your IP address ranges can be used for each accelerator. If you
         *        specify only one IP address from your IP address range, Global Accelerator assigns a second static IP
         *        address for the accelerator from the AWS IP address pool.
         *        </p>
         *        <p>
         *        Note that you can't update IP addresses for an existing accelerator. To change them, you must create a
         *        new accelerator with the new addresses.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own IP
         *        Addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddresses(Collection<String> ipAddresses);

        /**
         * <p>
         * Optionally, if you've added your own IP address pool to Global Accelerator (BYOIP), you can choose IP
         * addresses from your own pool to use for the accelerator's static IP addresses when you create an accelerator.
         * You can specify one or two addresses, separated by a space. Do not include the /32 suffix.
         * </p>
         * <p>
         * Only one IP address from each of your IP address ranges can be used for each accelerator. If you specify only
         * one IP address from your IP address range, Global Accelerator assigns a second static IP address for the
         * accelerator from the AWS IP address pool.
         * </p>
         * <p>
         * Note that you can't update IP addresses for an existing accelerator. To change them, you must create a new
         * accelerator with the new addresses.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own IP Addresses
         * (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.
         * </p>
         * 
         * @param ipAddresses
         *        Optionally, if you've added your own IP address pool to Global Accelerator (BYOIP), you can choose IP
         *        addresses from your own pool to use for the accelerator's static IP addresses when you create an
         *        accelerator. You can specify one or two addresses, separated by a space. Do not include the /32
         *        suffix.</p>
         *        <p>
         *        Only one IP address from each of your IP address ranges can be used for each accelerator. If you
         *        specify only one IP address from your IP address range, Global Accelerator assigns a second static IP
         *        address for the accelerator from the AWS IP address pool.
         *        </p>
         *        <p>
         *        Note that you can't update IP addresses for an existing accelerator. To change them, you must create a
         *        new accelerator with the new addresses.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring Your Own IP
         *        Addresses (BYOIP)</a> in the <i>AWS Global Accelerator Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddresses(String... ipAddresses);

        /**
         * <p>
         * Indicates whether an accelerator is enabled. The value is true or false. The default value is true.
         * </p>
         * <p>
         * If the value is set to true, an accelerator cannot be deleted. If set to false, the accelerator can be
         * deleted.
         * </p>
         * 
         * @param enabled
         *        Indicates whether an accelerator is enabled. The value is true or false. The default value is true.
         *        </p>
         *        <p>
         *        If the value is set to true, an accelerator cannot be deleted. If set to false, the accelerator can be
         *        deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of an
         * accelerator.
         * </p>
         * 
         * @param idempotencyToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the
         *        uniqueness—of an accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idempotencyToken(String idempotencyToken);

        /**
         * <p>
         * Create tags for an accelerator.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in
         * AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.
         * </p>
         * 
         * @param tags
         *        Create tags for an accelerator.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html"
         *        >Tagging in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Create tags for an accelerator.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in
         * AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.
         * </p>
         * 
         * @param tags
         *        Create tags for an accelerator.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html"
         *        >Tagging in AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Create tags for an accelerator.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in
         * AWS Global Accelerator</a> in the <i>AWS Global Accelerator Developer Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlobalAcceleratorRequest.BuilderImpl implements Builder {
        private String name;

        private String ipAddressType;

        private List<String> ipAddresses = DefaultSdkAutoConstructList.getInstance();

        private Boolean enabled;

        private String idempotencyToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAcceleratorRequest model) {
            super(model);
            name(model.name);
            ipAddressType(model.ipAddressType);
            ipAddresses(model.ipAddresses);
            enabled(model.enabled);
            idempotencyToken(model.idempotencyToken);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getIpAddressType() {
            return ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        public final Collection<String> getIpAddresses() {
            if (ipAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return ipAddresses;
        }

        @Override
        public final Builder ipAddresses(Collection<String> ipAddresses) {
            this.ipAddresses = IpAddressesCopier.copy(ipAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipAddresses(String... ipAddresses) {
            ipAddresses(Arrays.asList(ipAddresses));
            return this;
        }

        public final void setIpAddresses(Collection<String> ipAddresses) {
            this.ipAddresses = IpAddressesCopier.copy(ipAddresses);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getIdempotencyToken() {
            return idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAcceleratorRequest build() {
            return new CreateAcceleratorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
