/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AllowCustomRoutingTrafficRequest extends GlobalAcceleratorRequest implements
        ToCopyableBuilder<AllowCustomRoutingTrafficRequest.Builder, AllowCustomRoutingTrafficRequest> {
    private static final SdkField<String> ENDPOINT_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointGroupArn").getter(getter(AllowCustomRoutingTrafficRequest::endpointGroupArn))
            .setter(setter(Builder::endpointGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointGroupArn").build()).build();

    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointId").getter(getter(AllowCustomRoutingTrafficRequest::endpointId))
            .setter(setter(Builder::endpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointId").build()).build();

    private static final SdkField<List<String>> DESTINATION_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DestinationAddresses")
            .getter(getter(AllowCustomRoutingTrafficRequest::destinationAddresses))
            .setter(setter(Builder::destinationAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Integer>> DESTINATION_PORTS_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("DestinationPorts")
            .getter(getter(AllowCustomRoutingTrafficRequest::destinationPorts))
            .setter(setter(Builder::destinationPorts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPorts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ALLOW_ALL_TRAFFIC_TO_ENDPOINT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("AllowAllTrafficToEndpoint")
            .getter(getter(AllowCustomRoutingTrafficRequest::allowAllTrafficToEndpoint))
            .setter(setter(Builder::allowAllTrafficToEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowAllTrafficToEndpoint").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_GROUP_ARN_FIELD,
            ENDPOINT_ID_FIELD, DESTINATION_ADDRESSES_FIELD, DESTINATION_PORTS_FIELD, ALLOW_ALL_TRAFFIC_TO_ENDPOINT_FIELD));

    private final String endpointGroupArn;

    private final String endpointId;

    private final List<String> destinationAddresses;

    private final List<Integer> destinationPorts;

    private final Boolean allowAllTrafficToEndpoint;

    private AllowCustomRoutingTrafficRequest(BuilderImpl builder) {
        super(builder);
        this.endpointGroupArn = builder.endpointGroupArn;
        this.endpointId = builder.endpointId;
        this.destinationAddresses = builder.destinationAddresses;
        this.destinationPorts = builder.destinationPorts;
        this.allowAllTrafficToEndpoint = builder.allowAllTrafficToEndpoint;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the endpoint group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the endpoint group.
     */
    public final String endpointGroupArn() {
        return endpointGroupArn;
    }

    /**
     * <p>
     * An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet ID.
     * </p>
     * 
     * @return An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet
     *         ID.
     */
    public final String endpointId() {
        return endpointId;
    }

    /**
     * Returns true if the DestinationAddresses property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasDestinationAddresses() {
        return destinationAddresses != null && !(destinationAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want to allow to
     * receive traffic. The IP addresses must be a subset of the IP addresses that you specified for the endpoint group.
     * </p>
     * <p>
     * <code>DestinationAddresses</code> is required if <code>AllowAllTrafficToEndpoint</code> is <code>FALSE</code> or
     * is not specified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDestinationAddresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want to
     *         allow to receive traffic. The IP addresses must be a subset of the IP addresses that you specified for
     *         the endpoint group.</p>
     *         <p>
     *         <code>DestinationAddresses</code> is required if <code>AllowAllTrafficToEndpoint</code> is
     *         <code>FALSE</code> or is not specified.
     */
    public final List<String> destinationAddresses() {
        return destinationAddresses;
    }

    /**
     * Returns true if the DestinationPorts property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasDestinationPorts() {
        return destinationPorts != null && !(destinationPorts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of specific Amazon EC2 instance ports (destination ports) that you want to allow to receive traffic.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDestinationPorts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of specific Amazon EC2 instance ports (destination ports) that you want to allow to receive
     *         traffic.
     */
    public final List<Integer> destinationPorts() {
        return destinationPorts;
    }

    /**
     * <p>
     * Indicates whether all destination IP addresses and ports for a specified VPC subnet endpoint can receive traffic
     * from a custom routing accelerator. The value is TRUE or FALSE.
     * </p>
     * <p>
     * When set to TRUE, <i>all</i> destinations in the custom routing VPC subnet can receive traffic. Note that you
     * cannot specify destination IP addresses and ports when the value is set to TRUE.
     * </p>
     * <p>
     * When set to FALSE (or not specified), you <i>must</i> specify a list of destination IP addresses that are allowed
     * to receive traffic. A list of ports is optional. If you don't specify a list of ports, the ports that can accept
     * traffic is the same as the ports configured for the endpoint group.
     * </p>
     * <p>
     * The default value is FALSE.
     * </p>
     * 
     * @return Indicates whether all destination IP addresses and ports for a specified VPC subnet endpoint can receive
     *         traffic from a custom routing accelerator. The value is TRUE or FALSE. </p>
     *         <p>
     *         When set to TRUE, <i>all</i> destinations in the custom routing VPC subnet can receive traffic. Note that
     *         you cannot specify destination IP addresses and ports when the value is set to TRUE.
     *         </p>
     *         <p>
     *         When set to FALSE (or not specified), you <i>must</i> specify a list of destination IP addresses that are
     *         allowed to receive traffic. A list of ports is optional. If you don't specify a list of ports, the ports
     *         that can accept traffic is the same as the ports configured for the endpoint group.
     *         </p>
     *         <p>
     *         The default value is FALSE.
     */
    public final Boolean allowAllTrafficToEndpoint() {
        return allowAllTrafficToEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinationAddresses() ? destinationAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinationPorts() ? destinationPorts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(allowAllTrafficToEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllowCustomRoutingTrafficRequest)) {
            return false;
        }
        AllowCustomRoutingTrafficRequest other = (AllowCustomRoutingTrafficRequest) obj;
        return Objects.equals(endpointGroupArn(), other.endpointGroupArn()) && Objects.equals(endpointId(), other.endpointId())
                && hasDestinationAddresses() == other.hasDestinationAddresses()
                && Objects.equals(destinationAddresses(), other.destinationAddresses())
                && hasDestinationPorts() == other.hasDestinationPorts()
                && Objects.equals(destinationPorts(), other.destinationPorts())
                && Objects.equals(allowAllTrafficToEndpoint(), other.allowAllTrafficToEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AllowCustomRoutingTrafficRequest").add("EndpointGroupArn", endpointGroupArn())
                .add("EndpointId", endpointId())
                .add("DestinationAddresses", hasDestinationAddresses() ? destinationAddresses() : null)
                .add("DestinationPorts", hasDestinationPorts() ? destinationPorts() : null)
                .add("AllowAllTrafficToEndpoint", allowAllTrafficToEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointGroupArn":
            return Optional.ofNullable(clazz.cast(endpointGroupArn()));
        case "EndpointId":
            return Optional.ofNullable(clazz.cast(endpointId()));
        case "DestinationAddresses":
            return Optional.ofNullable(clazz.cast(destinationAddresses()));
        case "DestinationPorts":
            return Optional.ofNullable(clazz.cast(destinationPorts()));
        case "AllowAllTrafficToEndpoint":
            return Optional.ofNullable(clazz.cast(allowAllTrafficToEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AllowCustomRoutingTrafficRequest, T> g) {
        return obj -> g.apply((AllowCustomRoutingTrafficRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlobalAcceleratorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AllowCustomRoutingTrafficRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the endpoint group.
         * </p>
         * 
         * @param endpointGroupArn
         *        The Amazon Resource Name (ARN) of the endpoint group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointGroupArn(String endpointGroupArn);

        /**
         * <p>
         * An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC) subnet ID.
         * </p>
         * 
         * @param endpointId
         *        An ID for the endpoint. For custom routing accelerators, this is the virtual private cloud (VPC)
         *        subnet ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointId(String endpointId);

        /**
         * <p>
         * A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want to
         * allow to receive traffic. The IP addresses must be a subset of the IP addresses that you specified for the
         * endpoint group.
         * </p>
         * <p>
         * <code>DestinationAddresses</code> is required if <code>AllowAllTrafficToEndpoint</code> is <code>FALSE</code>
         * or is not specified.
         * </p>
         * 
         * @param destinationAddresses
         *        A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want
         *        to allow to receive traffic. The IP addresses must be a subset of the IP addresses that you specified
         *        for the endpoint group.</p>
         *        <p>
         *        <code>DestinationAddresses</code> is required if <code>AllowAllTrafficToEndpoint</code> is
         *        <code>FALSE</code> or is not specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationAddresses(Collection<String> destinationAddresses);

        /**
         * <p>
         * A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want to
         * allow to receive traffic. The IP addresses must be a subset of the IP addresses that you specified for the
         * endpoint group.
         * </p>
         * <p>
         * <code>DestinationAddresses</code> is required if <code>AllowAllTrafficToEndpoint</code> is <code>FALSE</code>
         * or is not specified.
         * </p>
         * 
         * @param destinationAddresses
         *        A list of specific Amazon EC2 instance IP addresses (destination addresses) in a subnet that you want
         *        to allow to receive traffic. The IP addresses must be a subset of the IP addresses that you specified
         *        for the endpoint group.</p>
         *        <p>
         *        <code>DestinationAddresses</code> is required if <code>AllowAllTrafficToEndpoint</code> is
         *        <code>FALSE</code> or is not specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationAddresses(String... destinationAddresses);

        /**
         * <p>
         * A list of specific Amazon EC2 instance ports (destination ports) that you want to allow to receive traffic.
         * </p>
         * 
         * @param destinationPorts
         *        A list of specific Amazon EC2 instance ports (destination ports) that you want to allow to receive
         *        traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPorts(Collection<Integer> destinationPorts);

        /**
         * <p>
         * A list of specific Amazon EC2 instance ports (destination ports) that you want to allow to receive traffic.
         * </p>
         * 
         * @param destinationPorts
         *        A list of specific Amazon EC2 instance ports (destination ports) that you want to allow to receive
         *        traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPorts(Integer... destinationPorts);

        /**
         * <p>
         * Indicates whether all destination IP addresses and ports for a specified VPC subnet endpoint can receive
         * traffic from a custom routing accelerator. The value is TRUE or FALSE.
         * </p>
         * <p>
         * When set to TRUE, <i>all</i> destinations in the custom routing VPC subnet can receive traffic. Note that you
         * cannot specify destination IP addresses and ports when the value is set to TRUE.
         * </p>
         * <p>
         * When set to FALSE (or not specified), you <i>must</i> specify a list of destination IP addresses that are
         * allowed to receive traffic. A list of ports is optional. If you don't specify a list of ports, the ports that
         * can accept traffic is the same as the ports configured for the endpoint group.
         * </p>
         * <p>
         * The default value is FALSE.
         * </p>
         * 
         * @param allowAllTrafficToEndpoint
         *        Indicates whether all destination IP addresses and ports for a specified VPC subnet endpoint can
         *        receive traffic from a custom routing accelerator. The value is TRUE or FALSE. </p>
         *        <p>
         *        When set to TRUE, <i>all</i> destinations in the custom routing VPC subnet can receive traffic. Note
         *        that you cannot specify destination IP addresses and ports when the value is set to TRUE.
         *        </p>
         *        <p>
         *        When set to FALSE (or not specified), you <i>must</i> specify a list of destination IP addresses that
         *        are allowed to receive traffic. A list of ports is optional. If you don't specify a list of ports, the
         *        ports that can accept traffic is the same as the ports configured for the endpoint group.
         *        </p>
         *        <p>
         *        The default value is FALSE.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowAllTrafficToEndpoint(Boolean allowAllTrafficToEndpoint);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlobalAcceleratorRequest.BuilderImpl implements Builder {
        private String endpointGroupArn;

        private String endpointId;

        private List<String> destinationAddresses = DefaultSdkAutoConstructList.getInstance();

        private List<Integer> destinationPorts = DefaultSdkAutoConstructList.getInstance();

        private Boolean allowAllTrafficToEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(AllowCustomRoutingTrafficRequest model) {
            super(model);
            endpointGroupArn(model.endpointGroupArn);
            endpointId(model.endpointId);
            destinationAddresses(model.destinationAddresses);
            destinationPorts(model.destinationPorts);
            allowAllTrafficToEndpoint(model.allowAllTrafficToEndpoint);
        }

        public final String getEndpointGroupArn() {
            return endpointGroupArn;
        }

        @Override
        public final Builder endpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
            return this;
        }

        public final void setEndpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
        }

        public final String getEndpointId() {
            return endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        public final Collection<String> getDestinationAddresses() {
            if (destinationAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return destinationAddresses;
        }

        @Override
        public final Builder destinationAddresses(Collection<String> destinationAddresses) {
            this.destinationAddresses = DestinationAddressesCopier.copy(destinationAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationAddresses(String... destinationAddresses) {
            destinationAddresses(Arrays.asList(destinationAddresses));
            return this;
        }

        public final void setDestinationAddresses(Collection<String> destinationAddresses) {
            this.destinationAddresses = DestinationAddressesCopier.copy(destinationAddresses);
        }

        public final Collection<Integer> getDestinationPorts() {
            if (destinationPorts instanceof SdkAutoConstructList) {
                return null;
            }
            return destinationPorts;
        }

        @Override
        public final Builder destinationPorts(Collection<Integer> destinationPorts) {
            this.destinationPorts = DestinationPortsCopier.copy(destinationPorts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationPorts(Integer... destinationPorts) {
            destinationPorts(Arrays.asList(destinationPorts));
            return this;
        }

        public final void setDestinationPorts(Collection<Integer> destinationPorts) {
            this.destinationPorts = DestinationPortsCopier.copy(destinationPorts);
        }

        public final Boolean getAllowAllTrafficToEndpoint() {
            return allowAllTrafficToEndpoint;
        }

        @Override
        public final Builder allowAllTrafficToEndpoint(Boolean allowAllTrafficToEndpoint) {
            this.allowAllTrafficToEndpoint = allowAllTrafficToEndpoint;
            return this;
        }

        public final void setAllowAllTrafficToEndpoint(Boolean allowAllTrafficToEndpoint) {
            this.allowAllTrafficToEndpoint = allowAllTrafficToEndpoint;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AllowCustomRoutingTrafficRequest build() {
            return new AllowCustomRoutingTrafficRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
