/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEndpointGroupRequest extends GlobalAcceleratorRequest implements
        ToCopyableBuilder<UpdateEndpointGroupRequest.Builder, UpdateEndpointGroupRequest> {
    private static final SdkField<String> ENDPOINT_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateEndpointGroupRequest::endpointGroupArn)).setter(setter(Builder::endpointGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointGroupArn").build()).build();

    private static final SdkField<List<EndpointConfiguration>> ENDPOINT_CONFIGURATIONS_FIELD = SdkField
            .<List<EndpointConfiguration>> builder(MarshallingType.LIST)
            .getter(getter(UpdateEndpointGroupRequest::endpointConfigurations))
            .setter(setter(Builder::endpointConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EndpointConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(EndpointConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Float> TRAFFIC_DIAL_PERCENTAGE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .getter(getter(UpdateEndpointGroupRequest::trafficDialPercentage)).setter(setter(Builder::trafficDialPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficDialPercentage").build())
            .build();

    private static final SdkField<Integer> HEALTH_CHECK_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateEndpointGroupRequest::healthCheckPort)).setter(setter(Builder::healthCheckPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckPort").build()).build();

    private static final SdkField<String> HEALTH_CHECK_PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateEndpointGroupRequest::healthCheckProtocolAsString)).setter(setter(Builder::healthCheckProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckProtocol").build())
            .build();

    private static final SdkField<String> HEALTH_CHECK_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateEndpointGroupRequest::healthCheckPath)).setter(setter(Builder::healthCheckPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckPath").build()).build();

    private static final SdkField<Integer> HEALTH_CHECK_INTERVAL_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateEndpointGroupRequest::healthCheckIntervalSeconds))
            .setter(setter(Builder::healthCheckIntervalSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckIntervalSeconds").build())
            .build();

    private static final SdkField<Integer> THRESHOLD_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateEndpointGroupRequest::thresholdCount)).setter(setter(Builder::thresholdCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThresholdCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_GROUP_ARN_FIELD,
            ENDPOINT_CONFIGURATIONS_FIELD, TRAFFIC_DIAL_PERCENTAGE_FIELD, HEALTH_CHECK_PORT_FIELD, HEALTH_CHECK_PROTOCOL_FIELD,
            HEALTH_CHECK_PATH_FIELD, HEALTH_CHECK_INTERVAL_SECONDS_FIELD, THRESHOLD_COUNT_FIELD));

    private final String endpointGroupArn;

    private final List<EndpointConfiguration> endpointConfigurations;

    private final Float trafficDialPercentage;

    private final Integer healthCheckPort;

    private final String healthCheckProtocol;

    private final String healthCheckPath;

    private final Integer healthCheckIntervalSeconds;

    private final Integer thresholdCount;

    private UpdateEndpointGroupRequest(BuilderImpl builder) {
        super(builder);
        this.endpointGroupArn = builder.endpointGroupArn;
        this.endpointConfigurations = builder.endpointConfigurations;
        this.trafficDialPercentage = builder.trafficDialPercentage;
        this.healthCheckPort = builder.healthCheckPort;
        this.healthCheckProtocol = builder.healthCheckProtocol;
        this.healthCheckPath = builder.healthCheckPath;
        this.healthCheckIntervalSeconds = builder.healthCheckIntervalSeconds;
        this.thresholdCount = builder.thresholdCount;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the endpoint group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the endpoint group.
     */
    public String endpointGroupArn() {
        return endpointGroupArn;
    }

    /**
     * Returns true if the EndpointConfigurations property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasEndpointConfigurations() {
        return endpointConfigurations != null && !(endpointConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of endpoint objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEndpointConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of endpoint objects.
     */
    public List<EndpointConfiguration> endpointConfigurations() {
        return endpointConfigurations;
    }

    /**
     * <p>
     * The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint groups
     * for this listener.
     * </p>
     * <p>
     * Use this action to increase (dial up) or decrease (dial down) traffic to a specific Region. The percentage is
     * applied to the traffic that would otherwise have been routed to the Region based on optimal routing.
     * </p>
     * <p>
     * The default value is 100.
     * </p>
     * 
     * @return The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint
     *         groups for this listener. </p>
     *         <p>
     *         Use this action to increase (dial up) or decrease (dial down) traffic to a specific Region. The
     *         percentage is applied to the traffic that would otherwise have been routed to the Region based on optimal
     *         routing.
     *         </p>
     *         <p>
     *         The default value is 100.
     */
    public Float trafficDialPercentage() {
        return trafficDialPercentage;
    }

    /**
     * <p>
     * The port that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint group.
     * The default port is the listener port that this endpoint group is associated with. If the listener port is a list
     * of ports, Global Accelerator uses the first port in the list.
     * </p>
     * 
     * @return The port that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint
     *         group. The default port is the listener port that this endpoint group is associated with. If the listener
     *         port is a list of ports, Global Accelerator uses the first port in the list.
     */
    public Integer healthCheckPort() {
        return healthCheckPort;
    }

    /**
     * <p>
     * The protocol that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint
     * group. The default value is TCP.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #healthCheckProtocol} will return {@link HealthCheckProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #healthCheckProtocolAsString}.
     * </p>
     * 
     * @return The protocol that AWS Global Accelerator uses to check the health of endpoints that are part of this
     *         endpoint group. The default value is TCP.
     * @see HealthCheckProtocol
     */
    public HealthCheckProtocol healthCheckProtocol() {
        return HealthCheckProtocol.fromValue(healthCheckProtocol);
    }

    /**
     * <p>
     * The protocol that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint
     * group. The default value is TCP.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #healthCheckProtocol} will return {@link HealthCheckProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #healthCheckProtocolAsString}.
     * </p>
     * 
     * @return The protocol that AWS Global Accelerator uses to check the health of endpoints that are part of this
     *         endpoint group. The default value is TCP.
     * @see HealthCheckProtocol
     */
    public String healthCheckProtocolAsString() {
        return healthCheckProtocol;
    }

    /**
     * <p>
     * If the protocol is HTTP/S, then this specifies the path that is the destination for health check targets. The
     * default value is slash (/).
     * </p>
     * 
     * @return If the protocol is HTTP/S, then this specifies the path that is the destination for health check targets.
     *         The default value is slash (/).
     */
    public String healthCheckPath() {
        return healthCheckPath;
    }

    /**
     * <p>
     * The time—10 seconds or 30 seconds—between each health check for an endpoint. The default value is 30.
     * </p>
     * 
     * @return The time—10 seconds or 30 seconds—between each health check for an endpoint. The default value is 30.
     */
    public Integer healthCheckIntervalSeconds() {
        return healthCheckIntervalSeconds;
    }

    /**
     * <p>
     * The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set
     * an unhealthy endpoint to healthy. The default value is 3.
     * </p>
     * 
     * @return The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or
     *         to set an unhealthy endpoint to healthy. The default value is 3.
     */
    public Integer thresholdCount() {
        return thresholdCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(endpointConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(trafficDialPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckPort());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckPath());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckIntervalSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(thresholdCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEndpointGroupRequest)) {
            return false;
        }
        UpdateEndpointGroupRequest other = (UpdateEndpointGroupRequest) obj;
        return Objects.equals(endpointGroupArn(), other.endpointGroupArn())
                && Objects.equals(endpointConfigurations(), other.endpointConfigurations())
                && Objects.equals(trafficDialPercentage(), other.trafficDialPercentage())
                && Objects.equals(healthCheckPort(), other.healthCheckPort())
                && Objects.equals(healthCheckProtocolAsString(), other.healthCheckProtocolAsString())
                && Objects.equals(healthCheckPath(), other.healthCheckPath())
                && Objects.equals(healthCheckIntervalSeconds(), other.healthCheckIntervalSeconds())
                && Objects.equals(thresholdCount(), other.thresholdCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateEndpointGroupRequest").add("EndpointGroupArn", endpointGroupArn())
                .add("EndpointConfigurations", endpointConfigurations()).add("TrafficDialPercentage", trafficDialPercentage())
                .add("HealthCheckPort", healthCheckPort()).add("HealthCheckProtocol", healthCheckProtocolAsString())
                .add("HealthCheckPath", healthCheckPath()).add("HealthCheckIntervalSeconds", healthCheckIntervalSeconds())
                .add("ThresholdCount", thresholdCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointGroupArn":
            return Optional.ofNullable(clazz.cast(endpointGroupArn()));
        case "EndpointConfigurations":
            return Optional.ofNullable(clazz.cast(endpointConfigurations()));
        case "TrafficDialPercentage":
            return Optional.ofNullable(clazz.cast(trafficDialPercentage()));
        case "HealthCheckPort":
            return Optional.ofNullable(clazz.cast(healthCheckPort()));
        case "HealthCheckProtocol":
            return Optional.ofNullable(clazz.cast(healthCheckProtocolAsString()));
        case "HealthCheckPath":
            return Optional.ofNullable(clazz.cast(healthCheckPath()));
        case "HealthCheckIntervalSeconds":
            return Optional.ofNullable(clazz.cast(healthCheckIntervalSeconds()));
        case "ThresholdCount":
            return Optional.ofNullable(clazz.cast(thresholdCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEndpointGroupRequest, T> g) {
        return obj -> g.apply((UpdateEndpointGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlobalAcceleratorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateEndpointGroupRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the endpoint group.
         * </p>
         * 
         * @param endpointGroupArn
         *        The Amazon Resource Name (ARN) of the endpoint group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointGroupArn(String endpointGroupArn);

        /**
         * <p>
         * The list of endpoint objects.
         * </p>
         * 
         * @param endpointConfigurations
         *        The list of endpoint objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointConfigurations(Collection<EndpointConfiguration> endpointConfigurations);

        /**
         * <p>
         * The list of endpoint objects.
         * </p>
         * 
         * @param endpointConfigurations
         *        The list of endpoint objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointConfigurations(EndpointConfiguration... endpointConfigurations);

        /**
         * <p>
         * The list of endpoint objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EndpointConfiguration>.Builder} avoiding
         * the need to create one manually via {@link List<EndpointConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EndpointConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link #endpointConfigurations(List<EndpointConfiguration>)}.
         * 
         * @param endpointConfigurations
         *        a consumer that will call methods on {@link List<EndpointConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointConfigurations(List<EndpointConfiguration>)
         */
        Builder endpointConfigurations(Consumer<EndpointConfiguration.Builder>... endpointConfigurations);

        /**
         * <p>
         * The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint
         * groups for this listener.
         * </p>
         * <p>
         * Use this action to increase (dial up) or decrease (dial down) traffic to a specific Region. The percentage is
         * applied to the traffic that would otherwise have been routed to the Region based on optimal routing.
         * </p>
         * <p>
         * The default value is 100.
         * </p>
         * 
         * @param trafficDialPercentage
         *        The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other
         *        endpoint groups for this listener. </p>
         *        <p>
         *        Use this action to increase (dial up) or decrease (dial down) traffic to a specific Region. The
         *        percentage is applied to the traffic that would otherwise have been routed to the Region based on
         *        optimal routing.
         *        </p>
         *        <p>
         *        The default value is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficDialPercentage(Float trafficDialPercentage);

        /**
         * <p>
         * The port that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint
         * group. The default port is the listener port that this endpoint group is associated with. If the listener
         * port is a list of ports, Global Accelerator uses the first port in the list.
         * </p>
         * 
         * @param healthCheckPort
         *        The port that AWS Global Accelerator uses to check the health of endpoints that are part of this
         *        endpoint group. The default port is the listener port that this endpoint group is associated with. If
         *        the listener port is a list of ports, Global Accelerator uses the first port in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckPort(Integer healthCheckPort);

        /**
         * <p>
         * The protocol that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint
         * group. The default value is TCP.
         * </p>
         * 
         * @param healthCheckProtocol
         *        The protocol that AWS Global Accelerator uses to check the health of endpoints that are part of this
         *        endpoint group. The default value is TCP.
         * @see HealthCheckProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HealthCheckProtocol
         */
        Builder healthCheckProtocol(String healthCheckProtocol);

        /**
         * <p>
         * The protocol that AWS Global Accelerator uses to check the health of endpoints that are part of this endpoint
         * group. The default value is TCP.
         * </p>
         * 
         * @param healthCheckProtocol
         *        The protocol that AWS Global Accelerator uses to check the health of endpoints that are part of this
         *        endpoint group. The default value is TCP.
         * @see HealthCheckProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HealthCheckProtocol
         */
        Builder healthCheckProtocol(HealthCheckProtocol healthCheckProtocol);

        /**
         * <p>
         * If the protocol is HTTP/S, then this specifies the path that is the destination for health check targets. The
         * default value is slash (/).
         * </p>
         * 
         * @param healthCheckPath
         *        If the protocol is HTTP/S, then this specifies the path that is the destination for health check
         *        targets. The default value is slash (/).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckPath(String healthCheckPath);

        /**
         * <p>
         * The time—10 seconds or 30 seconds—between each health check for an endpoint. The default value is 30.
         * </p>
         * 
         * @param healthCheckIntervalSeconds
         *        The time—10 seconds or 30 seconds—between each health check for an endpoint. The default value is 30.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckIntervalSeconds(Integer healthCheckIntervalSeconds);

        /**
         * <p>
         * The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to
         * set an unhealthy endpoint to healthy. The default value is 3.
         * </p>
         * 
         * @param thresholdCount
         *        The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy,
         *        or to set an unhealthy endpoint to healthy. The default value is 3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thresholdCount(Integer thresholdCount);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlobalAcceleratorRequest.BuilderImpl implements Builder {
        private String endpointGroupArn;

        private List<EndpointConfiguration> endpointConfigurations = DefaultSdkAutoConstructList.getInstance();

        private Float trafficDialPercentage;

        private Integer healthCheckPort;

        private String healthCheckProtocol;

        private String healthCheckPath;

        private Integer healthCheckIntervalSeconds;

        private Integer thresholdCount;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEndpointGroupRequest model) {
            super(model);
            endpointGroupArn(model.endpointGroupArn);
            endpointConfigurations(model.endpointConfigurations);
            trafficDialPercentage(model.trafficDialPercentage);
            healthCheckPort(model.healthCheckPort);
            healthCheckProtocol(model.healthCheckProtocol);
            healthCheckPath(model.healthCheckPath);
            healthCheckIntervalSeconds(model.healthCheckIntervalSeconds);
            thresholdCount(model.thresholdCount);
        }

        public final String getEndpointGroupArn() {
            return endpointGroupArn;
        }

        @Override
        public final Builder endpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
            return this;
        }

        public final void setEndpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
        }

        public final Collection<EndpointConfiguration.Builder> getEndpointConfigurations() {
            return endpointConfigurations != null ? endpointConfigurations.stream().map(EndpointConfiguration::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder endpointConfigurations(Collection<EndpointConfiguration> endpointConfigurations) {
            this.endpointConfigurations = EndpointConfigurationsCopier.copy(endpointConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointConfigurations(EndpointConfiguration... endpointConfigurations) {
            endpointConfigurations(Arrays.asList(endpointConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointConfigurations(Consumer<EndpointConfiguration.Builder>... endpointConfigurations) {
            endpointConfigurations(Stream.of(endpointConfigurations)
                    .map(c -> EndpointConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEndpointConfigurations(Collection<EndpointConfiguration.BuilderImpl> endpointConfigurations) {
            this.endpointConfigurations = EndpointConfigurationsCopier.copyFromBuilder(endpointConfigurations);
        }

        public final Float getTrafficDialPercentage() {
            return trafficDialPercentage;
        }

        @Override
        public final Builder trafficDialPercentage(Float trafficDialPercentage) {
            this.trafficDialPercentage = trafficDialPercentage;
            return this;
        }

        public final void setTrafficDialPercentage(Float trafficDialPercentage) {
            this.trafficDialPercentage = trafficDialPercentage;
        }

        public final Integer getHealthCheckPort() {
            return healthCheckPort;
        }

        @Override
        public final Builder healthCheckPort(Integer healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
            return this;
        }

        public final void setHealthCheckPort(Integer healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
        }

        public final String getHealthCheckProtocolAsString() {
            return healthCheckProtocol;
        }

        @Override
        public final Builder healthCheckProtocol(String healthCheckProtocol) {
            this.healthCheckProtocol = healthCheckProtocol;
            return this;
        }

        @Override
        public final Builder healthCheckProtocol(HealthCheckProtocol healthCheckProtocol) {
            this.healthCheckProtocol(healthCheckProtocol == null ? null : healthCheckProtocol.toString());
            return this;
        }

        public final void setHealthCheckProtocol(String healthCheckProtocol) {
            this.healthCheckProtocol = healthCheckProtocol;
        }

        public final String getHealthCheckPath() {
            return healthCheckPath;
        }

        @Override
        public final Builder healthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
            return this;
        }

        public final void setHealthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
        }

        public final Integer getHealthCheckIntervalSeconds() {
            return healthCheckIntervalSeconds;
        }

        @Override
        public final Builder healthCheckIntervalSeconds(Integer healthCheckIntervalSeconds) {
            this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
            return this;
        }

        public final void setHealthCheckIntervalSeconds(Integer healthCheckIntervalSeconds) {
            this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
        }

        public final Integer getThresholdCount() {
            return thresholdCount;
        }

        @Override
        public final Builder thresholdCount(Integer thresholdCount) {
            this.thresholdCount = thresholdCount;
            return this;
        }

        public final void setThresholdCount(Integer thresholdCount) {
            this.thresholdCount = thresholdCount;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEndpointGroupRequest build() {
            return new UpdateEndpointGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
