/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gameliftstreams.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gameliftstreams.GameLiftStreamsClient;
import software.amazon.awssdk.services.gameliftstreams.internal.UserAgentUtils;
import software.amazon.awssdk.services.gameliftstreams.model.ListStreamSessionsByAccountRequest;
import software.amazon.awssdk.services.gameliftstreams.model.ListStreamSessionsByAccountResponse;
import software.amazon.awssdk.services.gameliftstreams.model.StreamSessionSummary;

public class ListStreamSessionsByAccountIterable
implements SdkIterable<ListStreamSessionsByAccountResponse> {
    private final GameLiftStreamsClient client;
    private final ListStreamSessionsByAccountRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStreamSessionsByAccountIterable(GameLiftStreamsClient client, ListStreamSessionsByAccountRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListStreamSessionsByAccountResponseFetcher();
    }

    public Iterator<ListStreamSessionsByAccountResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StreamSessionSummary> items() {
        Function<ListStreamSessionsByAccountResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStreamSessionsByAccountResponseFetcher
    implements SyncPageFetcher<ListStreamSessionsByAccountResponse> {
        private ListStreamSessionsByAccountResponseFetcher() {
        }

        public boolean hasNextPage(ListStreamSessionsByAccountResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStreamSessionsByAccountResponse nextPage(ListStreamSessionsByAccountResponse previousPage) {
            if (previousPage == null) {
                return ListStreamSessionsByAccountIterable.this.client.listStreamSessionsByAccount(ListStreamSessionsByAccountIterable.this.firstRequest);
            }
            return ListStreamSessionsByAccountIterable.this.client.listStreamSessionsByAccount((ListStreamSessionsByAccountRequest)((Object)ListStreamSessionsByAccountIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

