/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gameliftstreams.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gameliftstreams.GameLiftStreamsClient;
import software.amazon.awssdk.services.gameliftstreams.internal.UserAgentUtils;
import software.amazon.awssdk.services.gameliftstreams.model.ListStreamGroupsRequest;
import software.amazon.awssdk.services.gameliftstreams.model.ListStreamGroupsResponse;
import software.amazon.awssdk.services.gameliftstreams.model.StreamGroupSummary;

public class ListStreamGroupsIterable
implements SdkIterable<ListStreamGroupsResponse> {
    private final GameLiftStreamsClient client;
    private final ListStreamGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStreamGroupsIterable(GameLiftStreamsClient client, ListStreamGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListStreamGroupsResponseFetcher();
    }

    public Iterator<ListStreamGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StreamGroupSummary> items() {
        Function<ListStreamGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStreamGroupsResponseFetcher
    implements SyncPageFetcher<ListStreamGroupsResponse> {
        private ListStreamGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListStreamGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStreamGroupsResponse nextPage(ListStreamGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListStreamGroupsIterable.this.client.listStreamGroups(ListStreamGroupsIterable.this.firstRequest);
            }
            return ListStreamGroupsIterable.this.client.listStreamGroups((ListStreamGroupsRequest)((Object)ListStreamGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

