/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVpcPeeringConnectionRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, CreateVpcPeeringConnectionRequest> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateVpcPeeringConnectionRequest.getter(CreateVpcPeeringConnectionRequest::fleetId)).setter(CreateVpcPeeringConnectionRequest.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()}).build();
    private static final SdkField<String> PEER_VPC_AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateVpcPeeringConnectionRequest.getter(CreateVpcPeeringConnectionRequest::peerVpcAwsAccountId)).setter(CreateVpcPeeringConnectionRequest.setter(Builder::peerVpcAwsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerVpcAwsAccountId").build()}).build();
    private static final SdkField<String> PEER_VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateVpcPeeringConnectionRequest.getter(CreateVpcPeeringConnectionRequest::peerVpcId)).setter(CreateVpcPeeringConnectionRequest.setter(Builder::peerVpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerVpcId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD, PEER_VPC_AWS_ACCOUNT_ID_FIELD, PEER_VPC_ID_FIELD));
    private final String fleetId;
    private final String peerVpcAwsAccountId;
    private final String peerVpcId;

    private CreateVpcPeeringConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.peerVpcAwsAccountId = builder.peerVpcAwsAccountId;
        this.peerVpcId = builder.peerVpcId;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public String peerVpcAwsAccountId() {
        return this.peerVpcAwsAccountId;
    }

    public String peerVpcId() {
        return this.peerVpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerVpcAwsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerVpcId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcPeeringConnectionRequest)) {
            return false;
        }
        CreateVpcPeeringConnectionRequest other = (CreateVpcPeeringConnectionRequest)((Object)obj);
        return Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.peerVpcAwsAccountId(), other.peerVpcAwsAccountId()) && Objects.equals(this.peerVpcId(), other.peerVpcId());
    }

    public String toString() {
        return ToString.builder((String)"CreateVpcPeeringConnectionRequest").add("FleetId", (Object)this.fleetId()).add("PeerVpcAwsAccountId", (Object)this.peerVpcAwsAccountId()).add("PeerVpcId", (Object)this.peerVpcId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "PeerVpcAwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.peerVpcAwsAccountId()));
            }
            case "PeerVpcId": {
                return Optional.ofNullable(clazz.cast(this.peerVpcId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcPeeringConnectionRequest, T> g) {
        return obj -> g.apply((CreateVpcPeeringConnectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String fleetId;
        private String peerVpcAwsAccountId;
        private String peerVpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcPeeringConnectionRequest model) {
            super(model);
            this.fleetId(model.fleetId);
            this.peerVpcAwsAccountId(model.peerVpcAwsAccountId);
            this.peerVpcId(model.peerVpcId);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final String getPeerVpcAwsAccountId() {
            return this.peerVpcAwsAccountId;
        }

        @Override
        public final Builder peerVpcAwsAccountId(String peerVpcAwsAccountId) {
            this.peerVpcAwsAccountId = peerVpcAwsAccountId;
            return this;
        }

        public final void setPeerVpcAwsAccountId(String peerVpcAwsAccountId) {
            this.peerVpcAwsAccountId = peerVpcAwsAccountId;
        }

        public final String getPeerVpcId() {
            return this.peerVpcId;
        }

        @Override
        public final Builder peerVpcId(String peerVpcId) {
            this.peerVpcId = peerVpcId;
            return this;
        }

        public final void setPeerVpcId(String peerVpcId) {
            this.peerVpcId = peerVpcId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcPeeringConnectionRequest build() {
            return new CreateVpcPeeringConnectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVpcPeeringConnectionRequest> {
        public Builder fleetId(String var1);

        public Builder peerVpcAwsAccountId(String var1);

        public Builder peerVpcId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

