/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.FleetAction;
import software.amazon.awssdk.services.gamelift.model.FleetActionListCopier;
import software.amazon.awssdk.services.gamelift.model.LocationState;
import software.amazon.awssdk.services.gamelift.model.LocationUpdateStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LocationAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LocationAttributes> {
    private static final SdkField<LocationState> LOCATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LocationState").getter(LocationAttributes.getter(LocationAttributes::locationState)).setter(LocationAttributes.setter(Builder::locationState)).constructor(LocationState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationState").build()}).build();
    private static final SdkField<List<String>> STOPPED_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StoppedActions").getter(LocationAttributes.getter(LocationAttributes::stoppedActionsAsStrings)).setter(LocationAttributes.setter(Builder::stoppedActionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppedActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> UPDATE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateStatus").getter(LocationAttributes.getter(LocationAttributes::updateStatusAsString)).setter(LocationAttributes.setter(Builder::updateStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_STATE_FIELD, STOPPED_ACTIONS_FIELD, UPDATE_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final LocationState locationState;
    private final List<String> stoppedActions;
    private final String updateStatus;

    private LocationAttributes(BuilderImpl builder) {
        this.locationState = builder.locationState;
        this.stoppedActions = builder.stoppedActions;
        this.updateStatus = builder.updateStatus;
    }

    public final LocationState locationState() {
        return this.locationState;
    }

    public final List<FleetAction> stoppedActions() {
        return FleetActionListCopier.copyStringToEnum(this.stoppedActions);
    }

    public final boolean hasStoppedActions() {
        return this.stoppedActions != null && !(this.stoppedActions instanceof SdkAutoConstructList);
    }

    public final List<String> stoppedActionsAsStrings() {
        return this.stoppedActions;
    }

    public final LocationUpdateStatus updateStatus() {
        return LocationUpdateStatus.fromValue(this.updateStatus);
    }

    public final String updateStatusAsString() {
        return this.updateStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.locationState());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStoppedActions() ? this.stoppedActionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updateStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocationAttributes)) {
            return false;
        }
        LocationAttributes other = (LocationAttributes)obj;
        return Objects.equals(this.locationState(), other.locationState()) && this.hasStoppedActions() == other.hasStoppedActions() && Objects.equals(this.stoppedActionsAsStrings(), other.stoppedActionsAsStrings()) && Objects.equals(this.updateStatusAsString(), other.updateStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LocationAttributes").add("LocationState", (Object)this.locationState()).add("StoppedActions", this.hasStoppedActions() ? this.stoppedActionsAsStrings() : null).add("UpdateStatus", (Object)this.updateStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocationState": {
                return Optional.ofNullable(clazz.cast(this.locationState()));
            }
            case "StoppedActions": {
                return Optional.ofNullable(clazz.cast(this.stoppedActionsAsStrings()));
            }
            case "UpdateStatus": {
                return Optional.ofNullable(clazz.cast(this.updateStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LocationAttributes, T> g) {
        return obj -> g.apply((LocationAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LocationState locationState;
        private List<String> stoppedActions = DefaultSdkAutoConstructList.getInstance();
        private String updateStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(LocationAttributes model) {
            this.locationState(model.locationState);
            this.stoppedActionsWithStrings(model.stoppedActions);
            this.updateStatus(model.updateStatus);
        }

        public final LocationState.Builder getLocationState() {
            return this.locationState != null ? this.locationState.toBuilder() : null;
        }

        public final void setLocationState(LocationState.BuilderImpl locationState) {
            this.locationState = locationState != null ? locationState.build() : null;
        }

        @Override
        public final Builder locationState(LocationState locationState) {
            this.locationState = locationState;
            return this;
        }

        public final Collection<String> getStoppedActions() {
            if (this.stoppedActions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stoppedActions;
        }

        public final void setStoppedActions(Collection<String> stoppedActions) {
            this.stoppedActions = FleetActionListCopier.copy(stoppedActions);
        }

        @Override
        public final Builder stoppedActionsWithStrings(Collection<String> stoppedActions) {
            this.stoppedActions = FleetActionListCopier.copy(stoppedActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stoppedActionsWithStrings(String ... stoppedActions) {
            this.stoppedActionsWithStrings(Arrays.asList(stoppedActions));
            return this;
        }

        @Override
        public final Builder stoppedActions(Collection<FleetAction> stoppedActions) {
            this.stoppedActions = FleetActionListCopier.copyEnumToString(stoppedActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stoppedActions(FleetAction ... stoppedActions) {
            this.stoppedActions(Arrays.asList(stoppedActions));
            return this;
        }

        public final String getUpdateStatus() {
            return this.updateStatus;
        }

        public final void setUpdateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
        }

        @Override
        public final Builder updateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
            return this;
        }

        @Override
        public final Builder updateStatus(LocationUpdateStatus updateStatus) {
            this.updateStatus(updateStatus == null ? null : updateStatus.toString());
            return this;
        }

        public LocationAttributes build() {
            return new LocationAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LocationAttributes> {
        public Builder locationState(LocationState var1);

        default public Builder locationState(Consumer<LocationState.Builder> locationState) {
            return this.locationState((LocationState)((LocationState.Builder)LocationState.builder().applyMutation(locationState)).build());
        }

        public Builder stoppedActionsWithStrings(Collection<String> var1);

        public Builder stoppedActionsWithStrings(String ... var1);

        public Builder stoppedActions(Collection<FleetAction> var1);

        public Builder stoppedActions(FleetAction ... var1);

        public Builder updateStatus(String var1);

        public Builder updateStatus(LocationUpdateStatus var1);
    }
}

