/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.ContainerDefinitionInput;
import software.amazon.awssdk.services.gamelift.model.ContainerDefinitionInputListCopier;
import software.amazon.awssdk.services.gamelift.model.ContainerOperatingSystem;
import software.amazon.awssdk.services.gamelift.model.ContainerSchedulingStrategy;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.Tag;
import software.amazon.awssdk.services.gamelift.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateContainerGroupDefinitionRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, CreateContainerGroupDefinitionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateContainerGroupDefinitionRequest.getter(CreateContainerGroupDefinitionRequest::name)).setter(CreateContainerGroupDefinitionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> SCHEDULING_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchedulingStrategy").getter(CreateContainerGroupDefinitionRequest.getter(CreateContainerGroupDefinitionRequest::schedulingStrategyAsString)).setter(CreateContainerGroupDefinitionRequest.setter(Builder::schedulingStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchedulingStrategy").build()}).build();
    private static final SdkField<Integer> TOTAL_MEMORY_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalMemoryLimit").getter(CreateContainerGroupDefinitionRequest.getter(CreateContainerGroupDefinitionRequest::totalMemoryLimit)).setter(CreateContainerGroupDefinitionRequest.setter(Builder::totalMemoryLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalMemoryLimit").build()}).build();
    private static final SdkField<Integer> TOTAL_CPU_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalCpuLimit").getter(CreateContainerGroupDefinitionRequest.getter(CreateContainerGroupDefinitionRequest::totalCpuLimit)).setter(CreateContainerGroupDefinitionRequest.setter(Builder::totalCpuLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCpuLimit").build()}).build();
    private static final SdkField<List<ContainerDefinitionInput>> CONTAINER_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContainerDefinitions").getter(CreateContainerGroupDefinitionRequest.getter(CreateContainerGroupDefinitionRequest::containerDefinitions)).setter(CreateContainerGroupDefinitionRequest.setter(Builder::containerDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContainerDefinitionInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperatingSystem").getter(CreateContainerGroupDefinitionRequest.getter(CreateContainerGroupDefinitionRequest::operatingSystemAsString)).setter(CreateContainerGroupDefinitionRequest.setter(Builder::operatingSystem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystem").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateContainerGroupDefinitionRequest.getter(CreateContainerGroupDefinitionRequest::tags)).setter(CreateContainerGroupDefinitionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SCHEDULING_STRATEGY_FIELD, TOTAL_MEMORY_LIMIT_FIELD, TOTAL_CPU_LIMIT_FIELD, CONTAINER_DEFINITIONS_FIELD, OPERATING_SYSTEM_FIELD, TAGS_FIELD));
    private final String name;
    private final String schedulingStrategy;
    private final Integer totalMemoryLimit;
    private final Integer totalCpuLimit;
    private final List<ContainerDefinitionInput> containerDefinitions;
    private final String operatingSystem;
    private final List<Tag> tags;

    private CreateContainerGroupDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.schedulingStrategy = builder.schedulingStrategy;
        this.totalMemoryLimit = builder.totalMemoryLimit;
        this.totalCpuLimit = builder.totalCpuLimit;
        this.containerDefinitions = builder.containerDefinitions;
        this.operatingSystem = builder.operatingSystem;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final ContainerSchedulingStrategy schedulingStrategy() {
        return ContainerSchedulingStrategy.fromValue(this.schedulingStrategy);
    }

    public final String schedulingStrategyAsString() {
        return this.schedulingStrategy;
    }

    public final Integer totalMemoryLimit() {
        return this.totalMemoryLimit;
    }

    public final Integer totalCpuLimit() {
        return this.totalCpuLimit;
    }

    public final boolean hasContainerDefinitions() {
        return this.containerDefinitions != null && !(this.containerDefinitions instanceof SdkAutoConstructList);
    }

    public final List<ContainerDefinitionInput> containerDefinitions() {
        return this.containerDefinitions;
    }

    public final ContainerOperatingSystem operatingSystem() {
        return ContainerOperatingSystem.fromValue(this.operatingSystem);
    }

    public final String operatingSystemAsString() {
        return this.operatingSystem;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedulingStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalMemoryLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCpuLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainerDefinitions() ? this.containerDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystemAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContainerGroupDefinitionRequest)) {
            return false;
        }
        CreateContainerGroupDefinitionRequest other = (CreateContainerGroupDefinitionRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.schedulingStrategyAsString(), other.schedulingStrategyAsString()) && Objects.equals(this.totalMemoryLimit(), other.totalMemoryLimit()) && Objects.equals(this.totalCpuLimit(), other.totalCpuLimit()) && this.hasContainerDefinitions() == other.hasContainerDefinitions() && Objects.equals(this.containerDefinitions(), other.containerDefinitions()) && Objects.equals(this.operatingSystemAsString(), other.operatingSystemAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateContainerGroupDefinitionRequest").add("Name", (Object)this.name()).add("SchedulingStrategy", (Object)this.schedulingStrategyAsString()).add("TotalMemoryLimit", (Object)this.totalMemoryLimit()).add("TotalCpuLimit", (Object)this.totalCpuLimit()).add("ContainerDefinitions", this.hasContainerDefinitions() ? this.containerDefinitions() : null).add("OperatingSystem", (Object)this.operatingSystemAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SchedulingStrategy": {
                return Optional.ofNullable(clazz.cast(this.schedulingStrategyAsString()));
            }
            case "TotalMemoryLimit": {
                return Optional.ofNullable(clazz.cast(this.totalMemoryLimit()));
            }
            case "TotalCpuLimit": {
                return Optional.ofNullable(clazz.cast(this.totalCpuLimit()));
            }
            case "ContainerDefinitions": {
                return Optional.ofNullable(clazz.cast(this.containerDefinitions()));
            }
            case "OperatingSystem": {
                return Optional.ofNullable(clazz.cast(this.operatingSystemAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateContainerGroupDefinitionRequest, T> g) {
        return obj -> g.apply((CreateContainerGroupDefinitionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String name;
        private String schedulingStrategy;
        private Integer totalMemoryLimit;
        private Integer totalCpuLimit;
        private List<ContainerDefinitionInput> containerDefinitions = DefaultSdkAutoConstructList.getInstance();
        private String operatingSystem;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContainerGroupDefinitionRequest model) {
            super(model);
            this.name(model.name);
            this.schedulingStrategy(model.schedulingStrategy);
            this.totalMemoryLimit(model.totalMemoryLimit);
            this.totalCpuLimit(model.totalCpuLimit);
            this.containerDefinitions(model.containerDefinitions);
            this.operatingSystem(model.operatingSystem);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSchedulingStrategy() {
            return this.schedulingStrategy;
        }

        public final void setSchedulingStrategy(String schedulingStrategy) {
            this.schedulingStrategy = schedulingStrategy;
        }

        @Override
        public final Builder schedulingStrategy(String schedulingStrategy) {
            this.schedulingStrategy = schedulingStrategy;
            return this;
        }

        @Override
        public final Builder schedulingStrategy(ContainerSchedulingStrategy schedulingStrategy) {
            this.schedulingStrategy(schedulingStrategy == null ? null : schedulingStrategy.toString());
            return this;
        }

        public final Integer getTotalMemoryLimit() {
            return this.totalMemoryLimit;
        }

        public final void setTotalMemoryLimit(Integer totalMemoryLimit) {
            this.totalMemoryLimit = totalMemoryLimit;
        }

        @Override
        public final Builder totalMemoryLimit(Integer totalMemoryLimit) {
            this.totalMemoryLimit = totalMemoryLimit;
            return this;
        }

        public final Integer getTotalCpuLimit() {
            return this.totalCpuLimit;
        }

        public final void setTotalCpuLimit(Integer totalCpuLimit) {
            this.totalCpuLimit = totalCpuLimit;
        }

        @Override
        public final Builder totalCpuLimit(Integer totalCpuLimit) {
            this.totalCpuLimit = totalCpuLimit;
            return this;
        }

        public final List<ContainerDefinitionInput.Builder> getContainerDefinitions() {
            List<ContainerDefinitionInput.Builder> result = ContainerDefinitionInputListCopier.copyToBuilder(this.containerDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainerDefinitions(Collection<ContainerDefinitionInput.BuilderImpl> containerDefinitions) {
            this.containerDefinitions = ContainerDefinitionInputListCopier.copyFromBuilder(containerDefinitions);
        }

        @Override
        public final Builder containerDefinitions(Collection<ContainerDefinitionInput> containerDefinitions) {
            this.containerDefinitions = ContainerDefinitionInputListCopier.copy(containerDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerDefinitions(ContainerDefinitionInput ... containerDefinitions) {
            this.containerDefinitions(Arrays.asList(containerDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerDefinitions(Consumer<ContainerDefinitionInput.Builder> ... containerDefinitions) {
            this.containerDefinitions(Stream.of(containerDefinitions).map(c -> (ContainerDefinitionInput)((ContainerDefinitionInput.Builder)ContainerDefinitionInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOperatingSystem() {
            return this.operatingSystem;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(ContainerOperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem == null ? null : operatingSystem.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateContainerGroupDefinitionRequest build() {
            return new CreateContainerGroupDefinitionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateContainerGroupDefinitionRequest> {
        public Builder name(String var1);

        public Builder schedulingStrategy(String var1);

        public Builder schedulingStrategy(ContainerSchedulingStrategy var1);

        public Builder totalMemoryLimit(Integer var1);

        public Builder totalCpuLimit(Integer var1);

        public Builder containerDefinitions(Collection<ContainerDefinitionInput> var1);

        public Builder containerDefinitions(ContainerDefinitionInput ... var1);

        public Builder containerDefinitions(Consumer<ContainerDefinitionInput.Builder> ... var1);

        public Builder operatingSystem(String var1);

        public Builder operatingSystem(ContainerOperatingSystem var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

