/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.gamelift.model.AcceptMatchRequest;

@SdkInternalApi
public class AcceptMatchRequestModelMarshaller {
    private static final MarshallingInfo<String> TICKETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TicketId").build();
    private static final MarshallingInfo<List> PLAYERIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlayerIds").build();
    private static final MarshallingInfo<String> ACCEPTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AcceptanceType").build();
    private static final AcceptMatchRequestModelMarshaller INSTANCE = new AcceptMatchRequestModelMarshaller();

    public static AcceptMatchRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AcceptMatchRequest acceptMatchRequest, ProtocolMarshaller protocolMarshaller) {
        if (acceptMatchRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)acceptMatchRequest.ticketId(), TICKETID_BINDING);
            protocolMarshaller.marshall(acceptMatchRequest.playerIds(), PLAYERIDS_BINDING);
            protocolMarshaller.marshall((Object)acceptMatchRequest.acceptanceTypeString(), ACCEPTANCETYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

