/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeGameSessionDetailsRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, DescribeGameSessionDetailsRequest> {
    private final String fleetId;
    private final String gameSessionId;
    private final String aliasId;
    private final String statusFilter;
    private final Integer limit;
    private final String nextToken;

    private DescribeGameSessionDetailsRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.gameSessionId = builder.gameSessionId;
        this.aliasId = builder.aliasId;
        this.statusFilter = builder.statusFilter;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public String gameSessionId() {
        return this.gameSessionId;
    }

    public String aliasId() {
        return this.aliasId;
    }

    public String statusFilter() {
        return this.statusFilter;
    }

    public Integer limit() {
        return this.limit;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.aliasId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGameSessionDetailsRequest)) {
            return false;
        }
        DescribeGameSessionDetailsRequest other = (DescribeGameSessionDetailsRequest)((Object)obj);
        return Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.gameSessionId(), other.gameSessionId()) && Objects.equals(this.aliasId(), other.aliasId()) && Objects.equals(this.statusFilter(), other.statusFilter()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeGameSessionDetailsRequest").add("FleetId", (Object)this.fleetId()).add("GameSessionId", (Object)this.gameSessionId()).add("AliasId", (Object)this.aliasId()).add("StatusFilter", (Object)this.statusFilter()).add("Limit", (Object)this.limit()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.of(clazz.cast(this.fleetId()));
            }
            case "GameSessionId": {
                return Optional.of(clazz.cast(this.gameSessionId()));
            }
            case "AliasId": {
                return Optional.of(clazz.cast(this.aliasId()));
            }
            case "StatusFilter": {
                return Optional.of(clazz.cast(this.statusFilter()));
            }
            case "Limit": {
                return Optional.of(clazz.cast(this.limit()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String fleetId;
        private String gameSessionId;
        private String aliasId;
        private String statusFilter;
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGameSessionDetailsRequest model) {
            this.fleetId(model.fleetId);
            this.gameSessionId(model.gameSessionId);
            this.aliasId(model.aliasId);
            this.statusFilter(model.statusFilter);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final String getGameSessionId() {
            return this.gameSessionId;
        }

        @Override
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        public final String getAliasId() {
            return this.aliasId;
        }

        @Override
        public final Builder aliasId(String aliasId) {
            this.aliasId = aliasId;
            return this;
        }

        public final void setAliasId(String aliasId) {
            this.aliasId = aliasId;
        }

        public final String getStatusFilter() {
            return this.statusFilter;
        }

        @Override
        public final Builder statusFilter(String statusFilter) {
            this.statusFilter = statusFilter;
            return this;
        }

        public final void setStatusFilter(String statusFilter) {
            this.statusFilter = statusFilter;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeGameSessionDetailsRequest build() {
            return new DescribeGameSessionDetailsRequest(this);
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    CopyableBuilder<Builder, DescribeGameSessionDetailsRequest> {
        public Builder fleetId(String var1);

        public Builder gameSessionId(String var1);

        public Builder aliasId(String var1);

        public Builder statusFilter(String var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

