/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreatePlayerSessionRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, CreatePlayerSessionRequest> {
    private final String gameSessionId;
    private final String playerId;
    private final String playerData;

    private CreatePlayerSessionRequest(BuilderImpl builder) {
        super(builder);
        this.gameSessionId = builder.gameSessionId;
        this.playerId = builder.playerId;
        this.playerData = builder.playerData;
    }

    public String gameSessionId() {
        return this.gameSessionId;
    }

    public String playerId() {
        return this.playerId;
    }

    public String playerData() {
        return this.playerData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.playerData());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlayerSessionRequest)) {
            return false;
        }
        CreatePlayerSessionRequest other = (CreatePlayerSessionRequest)((Object)obj);
        return Objects.equals(this.gameSessionId(), other.gameSessionId()) && Objects.equals(this.playerId(), other.playerId()) && Objects.equals(this.playerData(), other.playerData());
    }

    public String toString() {
        return ToString.builder((String)"CreatePlayerSessionRequest").add("GameSessionId", (Object)this.gameSessionId()).add("PlayerId", (Object)this.playerId()).add("PlayerData", (Object)this.playerData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameSessionId": {
                return Optional.of(clazz.cast(this.gameSessionId()));
            }
            case "PlayerId": {
                return Optional.of(clazz.cast(this.playerId()));
            }
            case "PlayerData": {
                return Optional.of(clazz.cast(this.playerData()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String gameSessionId;
        private String playerId;
        private String playerData;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlayerSessionRequest model) {
            this.gameSessionId(model.gameSessionId);
            this.playerId(model.playerId);
            this.playerData(model.playerData);
        }

        public final String getGameSessionId() {
            return this.gameSessionId;
        }

        @Override
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        public final String getPlayerId() {
            return this.playerId;
        }

        @Override
        public final Builder playerId(String playerId) {
            this.playerId = playerId;
            return this;
        }

        public final void setPlayerId(String playerId) {
            this.playerId = playerId;
        }

        public final String getPlayerData() {
            return this.playerData;
        }

        @Override
        public final Builder playerData(String playerData) {
            this.playerData = playerData;
            return this;
        }

        public final void setPlayerData(String playerData) {
            this.playerData = playerData;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreatePlayerSessionRequest build() {
            return new CreatePlayerSessionRequest(this);
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    CopyableBuilder<Builder, CreatePlayerSessionRequest> {
        public Builder gameSessionId(String var1);

        public Builder playerId(String var1);

        public Builder playerData(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

