/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.FSxRequest;
import software.amazon.awssdk.services.fsx.model.UpdateFileCacheLustreConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFileCacheRequest
extends FSxRequest
implements ToCopyableBuilder<Builder, UpdateFileCacheRequest> {
    private static final SdkField<String> FILE_CACHE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileCacheId").getter(UpdateFileCacheRequest.getter(UpdateFileCacheRequest::fileCacheId)).setter(UpdateFileCacheRequest.setter(Builder::fileCacheId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileCacheId").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(UpdateFileCacheRequest.getter(UpdateFileCacheRequest::clientRequestToken)).setter(UpdateFileCacheRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<UpdateFileCacheLustreConfiguration> LUSTRE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LustreConfiguration").getter(UpdateFileCacheRequest.getter(UpdateFileCacheRequest::lustreConfiguration)).setter(UpdateFileCacheRequest.setter(Builder::lustreConfiguration)).constructor(UpdateFileCacheLustreConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LustreConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_CACHE_ID_FIELD, CLIENT_REQUEST_TOKEN_FIELD, LUSTRE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateFileCacheRequest.memberNameToFieldInitializer();
    private final String fileCacheId;
    private final String clientRequestToken;
    private final UpdateFileCacheLustreConfiguration lustreConfiguration;

    private UpdateFileCacheRequest(BuilderImpl builder) {
        super(builder);
        this.fileCacheId = builder.fileCacheId;
        this.clientRequestToken = builder.clientRequestToken;
        this.lustreConfiguration = builder.lustreConfiguration;
    }

    public final String fileCacheId() {
        return this.fileCacheId;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final UpdateFileCacheLustreConfiguration lustreConfiguration() {
        return this.lustreConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fileCacheId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.lustreConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFileCacheRequest)) {
            return false;
        }
        UpdateFileCacheRequest other = (UpdateFileCacheRequest)((Object)obj);
        return Objects.equals(this.fileCacheId(), other.fileCacheId()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.lustreConfiguration(), other.lustreConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFileCacheRequest").add("FileCacheId", (Object)this.fileCacheId()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("LustreConfiguration", (Object)this.lustreConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileCacheId": {
                return Optional.ofNullable(clazz.cast(this.fileCacheId()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "LustreConfiguration": {
                return Optional.ofNullable(clazz.cast(this.lustreConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FileCacheId", FILE_CACHE_ID_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("LustreConfiguration", LUSTRE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFileCacheRequest, T> g) {
        return obj -> g.apply((UpdateFileCacheRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FSxRequest.BuilderImpl
    implements Builder {
        private String fileCacheId;
        private String clientRequestToken;
        private UpdateFileCacheLustreConfiguration lustreConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFileCacheRequest model) {
            super(model);
            this.fileCacheId(model.fileCacheId);
            this.clientRequestToken(model.clientRequestToken);
            this.lustreConfiguration(model.lustreConfiguration);
        }

        public final String getFileCacheId() {
            return this.fileCacheId;
        }

        public final void setFileCacheId(String fileCacheId) {
            this.fileCacheId = fileCacheId;
        }

        @Override
        public final Builder fileCacheId(String fileCacheId) {
            this.fileCacheId = fileCacheId;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final UpdateFileCacheLustreConfiguration.Builder getLustreConfiguration() {
            return this.lustreConfiguration != null ? this.lustreConfiguration.toBuilder() : null;
        }

        public final void setLustreConfiguration(UpdateFileCacheLustreConfiguration.BuilderImpl lustreConfiguration) {
            this.lustreConfiguration = lustreConfiguration != null ? lustreConfiguration.build() : null;
        }

        @Override
        public final Builder lustreConfiguration(UpdateFileCacheLustreConfiguration lustreConfiguration) {
            this.lustreConfiguration = lustreConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFileCacheRequest build() {
            return new UpdateFileCacheRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FSxRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFileCacheRequest> {
        public Builder fileCacheId(String var1);

        public Builder clientRequestToken(String var1);

        public Builder lustreConfiguration(UpdateFileCacheLustreConfiguration var1);

        default public Builder lustreConfiguration(Consumer<UpdateFileCacheLustreConfiguration.Builder> lustreConfiguration) {
            return this.lustreConfiguration((UpdateFileCacheLustreConfiguration)((UpdateFileCacheLustreConfiguration.Builder)UpdateFileCacheLustreConfiguration.builder().applyMutation(lustreConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

