/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecastquery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.forecastquery.model.FiltersCopier;
import software.amazon.awssdk.services.forecastquery.model.ForecastqueryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryForecastRequest
extends ForecastqueryRequest
implements ToCopyableBuilder<Builder, QueryForecastRequest> {
    private static final SdkField<String> FORECAST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ForecastArn").getter(QueryForecastRequest.getter(QueryForecastRequest::forecastArn)).setter(QueryForecastRequest.setter(Builder::forecastArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastArn").build()}).build();
    private static final SdkField<String> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartDate").getter(QueryForecastRequest.getter(QueryForecastRequest::startDate)).setter(QueryForecastRequest.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()}).build();
    private static final SdkField<String> END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndDate").getter(QueryForecastRequest.getter(QueryForecastRequest::endDate)).setter(QueryForecastRequest.setter(Builder::endDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").build()}).build();
    private static final SdkField<Map<String, String>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Filters").getter(QueryForecastRequest.getter(QueryForecastRequest::filters)).setter(QueryForecastRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(QueryForecastRequest.getter(QueryForecastRequest::nextToken)).setter(QueryForecastRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORECAST_ARN_FIELD, START_DATE_FIELD, END_DATE_FIELD, FILTERS_FIELD, NEXT_TOKEN_FIELD));
    private final String forecastArn;
    private final String startDate;
    private final String endDate;
    private final Map<String, String> filters;
    private final String nextToken;

    private QueryForecastRequest(BuilderImpl builder) {
        super(builder);
        this.forecastArn = builder.forecastArn;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
    }

    public final String forecastArn() {
        return this.forecastArn;
    }

    public final String startDate() {
        return this.startDate;
    }

    public final String endDate() {
        return this.endDate;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> filters() {
        return this.filters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.forecastArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryForecastRequest)) {
            return false;
        }
        QueryForecastRequest other = (QueryForecastRequest)((Object)obj);
        return Objects.equals(this.forecastArn(), other.forecastArn()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.endDate(), other.endDate()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"QueryForecastRequest").add("ForecastArn", (Object)this.forecastArn()).add("StartDate", (Object)this.startDate()).add("EndDate", (Object)this.endDate()).add("Filters", this.hasFilters() ? this.filters() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ForecastArn": {
                return Optional.ofNullable(clazz.cast(this.forecastArn()));
            }
            case "StartDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "EndDate": {
                return Optional.ofNullable(clazz.cast(this.endDate()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryForecastRequest, T> g) {
        return obj -> g.apply((QueryForecastRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastqueryRequest.BuilderImpl
    implements Builder {
        private String forecastArn;
        private String startDate;
        private String endDate;
        private Map<String, String> filters = DefaultSdkAutoConstructMap.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryForecastRequest model) {
            super(model);
            this.forecastArn(model.forecastArn);
            this.startDate(model.startDate);
            this.endDate(model.endDate);
            this.filters(model.filters);
            this.nextToken(model.nextToken);
        }

        public final String getForecastArn() {
            return this.forecastArn;
        }

        public final void setForecastArn(String forecastArn) {
            this.forecastArn = forecastArn;
        }

        @Override
        public final Builder forecastArn(String forecastArn) {
            this.forecastArn = forecastArn;
            return this;
        }

        public final String getStartDate() {
            return this.startDate;
        }

        public final void setStartDate(String startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public final String getEndDate() {
            return this.endDate;
        }

        public final void setEndDate(String endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(String endDate) {
            this.endDate = endDate;
            return this;
        }

        public final Map<String, String> getFilters() {
            if (this.filters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.filters;
        }

        public final void setFilters(Map<String, String> filters) {
            this.filters = FiltersCopier.copy(filters);
        }

        @Override
        public final Builder filters(Map<String, String> filters) {
            this.filters = FiltersCopier.copy(filters);
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public QueryForecastRequest build() {
            return new QueryForecastRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ForecastqueryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, QueryForecastRequest> {
        public Builder forecastArn(String var1);

        public Builder startDate(String var1);

        public Builder endDate(String var1);

        public Builder filters(Map<String, String> var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

