/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecastquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a forecast. Returned as part of the <a>QueryForecast</a> response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Forecast implements SdkPojo, Serializable, ToCopyableBuilder<Forecast.Builder, Forecast> {
    private static final SdkField<Map<String, List<DataPoint>>> PREDICTIONS_FIELD = SdkField
            .<Map<String, List<DataPoint>>> builder(MarshallingType.MAP)
            .memberName("Predictions")
            .getter(getter(Forecast::predictions))
            .setter(setter(Builder::predictions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Predictions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<DataPoint>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<DataPoint> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(DataPoint::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDICTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, List<DataPoint>> predictions;

    private Forecast(BuilderImpl builder) {
        this.predictions = builder.predictions;
    }

    /**
     * Returns true if the Predictions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPredictions() {
        return predictions != null && !(predictions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The forecast.
     * </p>
     * <p>
     * The <i>string</i> of the string-to-array map is one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * p10
     * </p>
     * </li>
     * <li>
     * <p>
     * p50
     * </p>
     * </li>
     * <li>
     * <p>
     * p90
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPredictions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The forecast.</p>
     *         <p>
     *         The <i>string</i> of the string-to-array map is one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         p10
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         p50
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         p90
     *         </p>
     *         </li>
     */
    public final Map<String, List<DataPoint>> predictions() {
        return predictions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPredictions() ? predictions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Forecast)) {
            return false;
        }
        Forecast other = (Forecast) obj;
        return hasPredictions() == other.hasPredictions() && Objects.equals(predictions(), other.predictions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Forecast").add("Predictions", hasPredictions() ? predictions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Predictions":
            return Optional.ofNullable(clazz.cast(predictions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Forecast, T> g) {
        return obj -> g.apply((Forecast) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Forecast> {
        /**
         * <p>
         * The forecast.
         * </p>
         * <p>
         * The <i>string</i> of the string-to-array map is one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * p10
         * </p>
         * </li>
         * <li>
         * <p>
         * p50
         * </p>
         * </li>
         * <li>
         * <p>
         * p90
         * </p>
         * </li>
         * </ul>
         * 
         * @param predictions
         *        The forecast.</p>
         *        <p>
         *        The <i>string</i> of the string-to-array map is one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        p10
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        p50
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        p90
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictions(Map<String, ? extends Collection<DataPoint>> predictions);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, List<DataPoint>> predictions = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Forecast model) {
            predictions(model.predictions);
        }

        public final Map<String, ? extends Collection<DataPoint>> getPredictions() {
            if (predictions instanceof SdkAutoConstructMap) {
                return null;
            }
            return predictions;
        }

        @Override
        public final Builder predictions(Map<String, ? extends Collection<DataPoint>> predictions) {
            this.predictions = PredictionsCopier.copy(predictions);
            return this;
        }

        public final void setPredictions(Map<String, ? extends Collection<DataPoint>> predictions) {
            this.predictions = PredictionsCopier.copy(predictions);
        }

        @Override
        public Forecast build() {
            return new Forecast(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
